/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetCalendarEventsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class GetCalendarEventsRequest
extends RequestBase {
    private final String calendarId;
    @Nullable
    private final DateTime end;
    @Nullable
    private final Integer from;
    @Nullable
    private final String jobId;
    @Nullable
    private final Integer size;
    @Nullable
    private final DateTime start;
    public static final Endpoint<GetCalendarEventsRequest, GetCalendarEventsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetCalendarEventsRequest, GetCalendarEventsResponse>("es/ml.get_calendar_events", request -> "GET", request -> {
        boolean _calendarId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/calendars");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.calendarId, buf);
            buf.append("/events");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _calendarId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("calendarId", request.calendarId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.jobId != null) {
            params.put("job_id", request.jobId);
        }
        if (request.start != null) {
            params.put("start", request.start.toString());
        }
        if (request.end != null) {
            params.put("end", request.end.toString());
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetCalendarEventsResponse._DESERIALIZER);

    private GetCalendarEventsRequest(Builder builder) {
        this.calendarId = ApiTypeHelper.requireNonNull(builder.calendarId, this, "calendarId");
        this.end = builder.end;
        this.from = builder.from;
        this.jobId = builder.jobId;
        this.size = builder.size;
        this.start = builder.start;
    }

    public static GetCalendarEventsRequest of(Function<Builder, ObjectBuilder<GetCalendarEventsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String calendarId() {
        return this.calendarId;
    }

    @Nullable
    public final DateTime end() {
        return this.end;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    @Nullable
    public final String jobId() {
        return this.jobId;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final DateTime start() {
        return this.start;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetCalendarEventsRequest> {
        private String calendarId;
        @Nullable
        private DateTime end;
        @Nullable
        private Integer from;
        @Nullable
        private String jobId;
        @Nullable
        private Integer size;
        @Nullable
        private DateTime start;

        public Builder() {
        }

        private Builder(GetCalendarEventsRequest instance) {
            this.calendarId = instance.calendarId;
            this.end = instance.end;
            this.from = instance.from;
            this.jobId = instance.jobId;
            this.size = instance.size;
            this.start = instance.start;
        }

        public final Builder calendarId(String value) {
            this.calendarId = value;
            return this;
        }

        public final Builder end(@Nullable DateTime value) {
            this.end = value;
            return this;
        }

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder jobId(@Nullable String value) {
            this.jobId = value;
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder start(@Nullable DateTime value) {
            this.start = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetCalendarEventsRequest build() {
            this._checkSingleUse();
            return new GetCalendarEventsRequest(this);
        }
    }
}

