/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ml.GetOverallBucketsResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetOverallBucketsRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Time bucketSpan;
    @Nullable
    private final DateTime end;
    @Nullable
    private final Boolean excludeInterim;
    private final String jobId;
    @Nullable
    private final Double overallScore;
    @Nullable
    private final DateTime start;
    @Nullable
    private final Integer topN;
    public static final JsonpDeserializer<GetOverallBucketsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetOverallBucketsRequest::setupGetOverallBucketsRequestDeserializer);
    public static final Endpoint<GetOverallBucketsRequest, GetOverallBucketsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetOverallBucketsRequest, GetOverallBucketsResponse>("es/ml.get_overall_buckets", request -> "POST", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/results");
            buf.append("/overall_buckets");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _jobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("jobId", request.jobId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, GetOverallBucketsResponse._DESERIALIZER);

    private GetOverallBucketsRequest(Builder builder) {
        this.allowNoMatch = builder.allowNoMatch;
        this.bucketSpan = builder.bucketSpan;
        this.end = builder.end;
        this.excludeInterim = builder.excludeInterim;
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.overallScore = builder.overallScore;
        this.start = builder.start;
        this.topN = builder.topN;
    }

    public static GetOverallBucketsRequest of(Function<Builder, ObjectBuilder<GetOverallBucketsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public final Time bucketSpan() {
        return this.bucketSpan;
    }

    @Nullable
    public final DateTime end() {
        return this.end;
    }

    @Nullable
    public final Boolean excludeInterim() {
        return this.excludeInterim;
    }

    public final String jobId() {
        return this.jobId;
    }

    @Nullable
    public final Double overallScore() {
        return this.overallScore;
    }

    @Nullable
    public final DateTime start() {
        return this.start;
    }

    @Nullable
    public final Integer topN() {
        return this.topN;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allowNoMatch != null) {
            generator.writeKey("allow_no_match");
            generator.write(this.allowNoMatch.booleanValue());
        }
        if (this.bucketSpan != null) {
            generator.writeKey("bucket_span");
            this.bucketSpan.serialize(generator, mapper);
        }
        if (this.end != null) {
            generator.writeKey("end");
            this.end.serialize(generator, mapper);
        }
        if (this.excludeInterim != null) {
            generator.writeKey("exclude_interim");
            generator.write(this.excludeInterim.booleanValue());
        }
        if (this.overallScore != null) {
            generator.writeKey("overall_score");
            generator.write(this.overallScore.doubleValue());
        }
        if (this.start != null) {
            generator.writeKey("start");
            this.start.serialize(generator, mapper);
        }
        if (this.topN != null) {
            generator.writeKey("top_n");
            generator.write(this.topN.intValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupGetOverallBucketsRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allowNoMatch, JsonpDeserializer.booleanDeserializer(), "allow_no_match");
        op.add(Builder::bucketSpan, Time._DESERIALIZER, "bucket_span");
        op.add(Builder::end, DateTime._DESERIALIZER, "end");
        op.add(Builder::excludeInterim, JsonpDeserializer.booleanDeserializer(), "exclude_interim");
        op.add(Builder::overallScore, JsonpDeserializer.doubleDeserializer(), "overall_score");
        op.add(Builder::start, DateTime._DESERIALIZER, "start");
        op.add(Builder::topN, JsonpDeserializer.integerDeserializer(), "top_n");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetOverallBucketsRequest> {
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Time bucketSpan;
        @Nullable
        private DateTime end;
        @Nullable
        private Boolean excludeInterim;
        private String jobId;
        @Nullable
        private Double overallScore;
        @Nullable
        private DateTime start;
        @Nullable
        private Integer topN;

        public Builder() {
        }

        private Builder(GetOverallBucketsRequest instance) {
            this.allowNoMatch = instance.allowNoMatch;
            this.bucketSpan = instance.bucketSpan;
            this.end = instance.end;
            this.excludeInterim = instance.excludeInterim;
            this.jobId = instance.jobId;
            this.overallScore = instance.overallScore;
            this.start = instance.start;
            this.topN = instance.topN;
        }

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder bucketSpan(@Nullable Time value) {
            this.bucketSpan = value;
            return this;
        }

        public final Builder bucketSpan(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.bucketSpan(fn.apply(new Time.Builder()).build());
        }

        public final Builder end(@Nullable DateTime value) {
            this.end = value;
            return this;
        }

        public final Builder excludeInterim(@Nullable Boolean value) {
            this.excludeInterim = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder overallScore(@Nullable Double value) {
            this.overallScore = value;
            return this;
        }

        public final Builder start(@Nullable DateTime value) {
            this.start = value;
            return this;
        }

        public final Builder topN(@Nullable Integer value) {
            this.topN = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetOverallBucketsRequest build() {
            this._checkSingleUse();
            return new GetOverallBucketsRequest(this);
        }
    }
}

