/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.nodes.NodesInfoResponse;
import co.elastic.clients.elasticsearch.nodes.info.NodesInfoMetric;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class NodesInfoRequest
extends RequestBase {
    @Nullable
    private final Boolean flatSettings;
    private final List<NodesInfoMetric> metric;
    private final List<String> nodeId;
    @Nullable
    private final Time timeout;
    public static final Endpoint<NodesInfoRequest, NodesInfoResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<NodesInfoRequest, NodesInfoResponse>("es/nodes.info", request -> "GET", request -> {
        boolean _metric = true;
        int _nodeId = 2;
        int propsSet = 0;
        if (ApiTypeHelper.isDefined(request.metric())) {
            propsSet |= 1;
        }
        if (ApiTypeHelper.isDefined(request.nodeId())) {
            propsSet |= 2;
        }
        if (propsSet == 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            return buf.toString();
        }
        if (propsSet == 2) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _metric = true;
        int _nodeId = 2;
        int propsSet = 0;
        if (ApiTypeHelper.isDefined(request.metric())) {
            propsSet |= 1;
        }
        if (ApiTypeHelper.isDefined(request.nodeId())) {
            propsSet |= 2;
        }
        if (propsSet == 0) {
            // empty if block
        }
        if (propsSet == 2) {
            params.put("nodeId", request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (propsSet == 1) {
            params.put("metric", request.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (propsSet == 3) {
            params.put("nodeId", request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")));
            params.put("metric", request.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.flatSettings != null) {
            params.put("flat_settings", String.valueOf(request.flatSettings));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, NodesInfoResponse._DESERIALIZER);

    private NodesInfoRequest(Builder builder) {
        this.flatSettings = builder.flatSettings;
        this.metric = ApiTypeHelper.unmodifiable(builder.metric);
        this.nodeId = ApiTypeHelper.unmodifiable(builder.nodeId);
        this.timeout = builder.timeout;
    }

    public static NodesInfoRequest of(Function<Builder, ObjectBuilder<NodesInfoRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean flatSettings() {
        return this.flatSettings;
    }

    public final List<NodesInfoMetric> metric() {
        return this.metric;
    }

    public final List<String> nodeId() {
        return this.nodeId;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<NodesInfoRequest> {
        @Nullable
        private Boolean flatSettings;
        @Nullable
        private List<NodesInfoMetric> metric;
        @Nullable
        private List<String> nodeId;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(NodesInfoRequest instance) {
            this.flatSettings = instance.flatSettings;
            this.metric = instance.metric;
            this.nodeId = instance.nodeId;
            this.timeout = instance.timeout;
        }

        public final Builder flatSettings(@Nullable Boolean value) {
            this.flatSettings = value;
            return this;
        }

        public final Builder metric(List<NodesInfoMetric> list) {
            this.metric = Builder._listAddAll(this.metric, list);
            return this;
        }

        public final Builder metric(NodesInfoMetric value, NodesInfoMetric ... values) {
            this.metric = Builder._listAdd(this.metric, value, values);
            return this;
        }

        public final Builder nodeId(List<String> list) {
            this.nodeId = Builder._listAddAll(this.nodeId, list);
            return this;
        }

        public final Builder nodeId(String value, String ... values) {
            this.nodeId = Builder._listAdd(this.nodeId, value, values);
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodesInfoRequest build() {
            this._checkSingleUse();
            return new NodesInfoRequest(this);
        }
    }
}

