/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.query_rules;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.query_rules.TestResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class TestRequest
extends RequestBase
implements JsonpSerializable {
    private final Map<String, JsonData> matchCriteria;
    private final String rulesetId;
    public static final JsonpDeserializer<TestRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TestRequest::setupTestRequestDeserializer);
    public static final Endpoint<TestRequest, TestResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<TestRequest, TestResponse>("es/query_rules.test", request -> "POST", request -> {
        boolean _rulesetId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_query_rules");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.rulesetId, buf);
            buf.append("/_test");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _rulesetId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("rulesetId", request.rulesetId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, TestResponse._DESERIALIZER);

    private TestRequest(Builder builder) {
        this.matchCriteria = ApiTypeHelper.unmodifiableRequired(builder.matchCriteria, (Object)this, "matchCriteria");
        this.rulesetId = ApiTypeHelper.requireNonNull(builder.rulesetId, this, "rulesetId");
    }

    public static TestRequest of(Function<Builder, ObjectBuilder<TestRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, JsonData> matchCriteria() {
        return this.matchCriteria;
    }

    public final String rulesetId() {
        return this.rulesetId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.matchCriteria)) {
            generator.writeKey("match_criteria");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.matchCriteria.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupTestRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::matchCriteria, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "match_criteria");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TestRequest> {
        private Map<String, JsonData> matchCriteria;
        private String rulesetId;

        public Builder() {
        }

        private Builder(TestRequest instance) {
            this.matchCriteria = instance.matchCriteria;
            this.rulesetId = instance.rulesetId;
        }

        public final Builder matchCriteria(Map<String, JsonData> map) {
            this.matchCriteria = Builder._mapPutAll(this.matchCriteria, map);
            return this;
        }

        public final Builder matchCriteria(String key, JsonData value) {
            this.matchCriteria = Builder._mapPut(this.matchCriteria, key, value);
            return this;
        }

        public final Builder rulesetId(String value) {
            this.rulesetId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TestRequest build() {
            this._checkSingleUse();
            return new TestRequest(this);
        }
    }
}

