/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.search_application;

import co.elastic.clients.elasticsearch.search_application.EventDataStream;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class AnalyticsCollection
implements JsonpSerializable {
    private final EventDataStream eventDataStream;
    public static final JsonpDeserializer<AnalyticsCollection> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AnalyticsCollection::setupAnalyticsCollectionDeserializer);

    private AnalyticsCollection(Builder builder) {
        this.eventDataStream = ApiTypeHelper.requireNonNull(builder.eventDataStream, this, "eventDataStream");
    }

    public static AnalyticsCollection of(Function<Builder, ObjectBuilder<AnalyticsCollection>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final EventDataStream eventDataStream() {
        return this.eventDataStream;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("event_data_stream");
        this.eventDataStream.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupAnalyticsCollectionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::eventDataStream, EventDataStream._DESERIALIZER, "event_data_stream");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AnalyticsCollection> {
        private EventDataStream eventDataStream;

        public Builder() {
        }

        private Builder(AnalyticsCollection instance) {
            this.eventDataStream = instance.eventDataStream;
        }

        public final Builder eventDataStream(EventDataStream value) {
            this.eventDataStream = value;
            return this;
        }

        public final Builder eventDataStream(Function<EventDataStream.Builder, ObjectBuilder<EventDataStream>> fn) {
            return this.eventDataStream(fn.apply(new EventDataStream.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AnalyticsCollection build() {
            this._checkSingleUse();
            return new AnalyticsCollection(this);
        }
    }
}

