/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.security.Access;
import co.elastic.clients.elasticsearch.security.CreateCrossClusterApiKeyResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CreateCrossClusterApiKeyRequest
extends RequestBase
implements JsonpSerializable {
    private final Access access;
    @Nullable
    private final String certificateIdentity;
    @Nullable
    private final Time expiration;
    private final Map<String, JsonData> metadata;
    private final String name;
    public static final JsonpDeserializer<CreateCrossClusterApiKeyRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CreateCrossClusterApiKeyRequest::setupCreateCrossClusterApiKeyRequestDeserializer);
    public static final Endpoint<CreateCrossClusterApiKeyRequest, CreateCrossClusterApiKeyResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CreateCrossClusterApiKeyRequest, CreateCrossClusterApiKeyResponse>("es/security.create_cross_cluster_api_key", request -> "POST", request -> "/_security/cross_cluster/api_key", request -> Collections.emptyMap(), request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, CreateCrossClusterApiKeyResponse._DESERIALIZER);

    private CreateCrossClusterApiKeyRequest(Builder builder) {
        this.access = ApiTypeHelper.requireNonNull(builder.access, this, "access");
        this.certificateIdentity = builder.certificateIdentity;
        this.expiration = builder.expiration;
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
    }

    public static CreateCrossClusterApiKeyRequest of(Function<Builder, ObjectBuilder<CreateCrossClusterApiKeyRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Access access() {
        return this.access;
    }

    @Nullable
    public final String certificateIdentity() {
        return this.certificateIdentity;
    }

    @Nullable
    public final Time expiration() {
        return this.expiration;
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("access");
        this.access.serialize(generator, mapper);
        if (this.certificateIdentity != null) {
            generator.writeKey("certificate_identity");
            generator.write(this.certificateIdentity);
        }
        if (this.expiration != null) {
            generator.writeKey("expiration");
            this.expiration.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.metadata.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("name");
        generator.write(this.name);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupCreateCrossClusterApiKeyRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::access, Access._DESERIALIZER, "access");
        op.add(Builder::certificateIdentity, JsonpDeserializer.stringDeserializer(), "certificate_identity");
        op.add(Builder::expiration, Time._DESERIALIZER, "expiration");
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CreateCrossClusterApiKeyRequest> {
        private Access access;
        @Nullable
        private String certificateIdentity;
        @Nullable
        private Time expiration;
        @Nullable
        private Map<String, JsonData> metadata;
        private String name;

        public Builder() {
        }

        private Builder(CreateCrossClusterApiKeyRequest instance) {
            this.access = instance.access;
            this.certificateIdentity = instance.certificateIdentity;
            this.expiration = instance.expiration;
            this.metadata = instance.metadata;
            this.name = instance.name;
        }

        public final Builder access(Access value) {
            this.access = value;
            return this;
        }

        public final Builder access(Function<Access.Builder, ObjectBuilder<Access>> fn) {
            return this.access(fn.apply(new Access.Builder()).build());
        }

        public final Builder certificateIdentity(@Nullable String value) {
            this.certificateIdentity = value;
            return this;
        }

        public final Builder expiration(@Nullable Time value) {
            this.expiration = value;
            return this;
        }

        public final Builder expiration(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.expiration(fn.apply(new Time.Builder()).build());
        }

        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CreateCrossClusterApiKeyRequest build() {
            this._checkSingleUse();
            return new CreateCrossClusterApiKeyRequest(this);
        }
    }
}

