/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.InvalidateTokenResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class InvalidateTokenRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String realmName;
    @Nullable
    private final String refreshToken;
    @Nullable
    private final String token;
    @Nullable
    private final String username;
    public static final JsonpDeserializer<InvalidateTokenRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InvalidateTokenRequest::setupInvalidateTokenRequestDeserializer);
    public static final Endpoint<InvalidateTokenRequest, InvalidateTokenResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<InvalidateTokenRequest, InvalidateTokenResponse>("es/security.invalidate_token", request -> "DELETE", request -> "/_security/oauth2/token", request -> Collections.emptyMap(), request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, InvalidateTokenResponse._DESERIALIZER);

    private InvalidateTokenRequest(Builder builder) {
        this.realmName = builder.realmName;
        this.refreshToken = builder.refreshToken;
        this.token = builder.token;
        this.username = builder.username;
    }

    public static InvalidateTokenRequest of(Function<Builder, ObjectBuilder<InvalidateTokenRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String realmName() {
        return this.realmName;
    }

    @Nullable
    public final String refreshToken() {
        return this.refreshToken;
    }

    @Nullable
    public final String token() {
        return this.token;
    }

    @Nullable
    public final String username() {
        return this.username;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.realmName != null) {
            generator.writeKey("realm_name");
            generator.write(this.realmName);
        }
        if (this.refreshToken != null) {
            generator.writeKey("refresh_token");
            generator.write(this.refreshToken);
        }
        if (this.token != null) {
            generator.writeKey("token");
            generator.write(this.token);
        }
        if (this.username != null) {
            generator.writeKey("username");
            generator.write(this.username);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupInvalidateTokenRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::realmName, JsonpDeserializer.stringDeserializer(), "realm_name");
        op.add(Builder::refreshToken, JsonpDeserializer.stringDeserializer(), "refresh_token");
        op.add(Builder::token, JsonpDeserializer.stringDeserializer(), "token");
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), "username");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<InvalidateTokenRequest> {
        @Nullable
        private String realmName;
        @Nullable
        private String refreshToken;
        @Nullable
        private String token;
        @Nullable
        private String username;

        public Builder() {
        }

        private Builder(InvalidateTokenRequest instance) {
            this.realmName = instance.realmName;
            this.refreshToken = instance.refreshToken;
            this.token = instance.token;
            this.username = instance.username;
        }

        public final Builder realmName(@Nullable String value) {
            this.realmName = value;
            return this;
        }

        public final Builder refreshToken(@Nullable String value) {
            this.refreshToken = value;
            return this;
        }

        public final Builder token(@Nullable String value) {
            this.token = value;
            return this;
        }

        public final Builder username(@Nullable String value) {
            this.username = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InvalidateTokenRequest build() {
            this._checkSingleUse();
            return new InvalidateTokenRequest(this);
        }
    }
}

