/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.FieldSecurity;
import co.elastic.clients.elasticsearch.security.IndicesPrivilegesQuery;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SearchAccess
implements JsonpSerializable {
    @Nullable
    private final FieldSecurity fieldSecurity;
    private final List<String> names;
    @Nullable
    private final IndicesPrivilegesQuery query;
    @Nullable
    private final Boolean allowRestrictedIndices;
    public static final JsonpDeserializer<SearchAccess> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchAccess::setupSearchAccessDeserializer);

    private SearchAccess(Builder builder) {
        this.fieldSecurity = builder.fieldSecurity;
        this.names = ApiTypeHelper.unmodifiableRequired(builder.names, (Object)this, "names");
        this.query = builder.query;
        this.allowRestrictedIndices = builder.allowRestrictedIndices;
    }

    public static SearchAccess of(Function<Builder, ObjectBuilder<SearchAccess>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final FieldSecurity fieldSecurity() {
        return this.fieldSecurity;
    }

    public final List<String> names() {
        return this.names;
    }

    @Nullable
    public final IndicesPrivilegesQuery query() {
        return this.query;
    }

    @Nullable
    public final Boolean allowRestrictedIndices() {
        return this.allowRestrictedIndices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.fieldSecurity != null) {
            generator.writeKey("field_security");
            this.fieldSecurity.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.names)) {
            generator.writeKey("names");
            generator.writeStartArray();
            for (String item0 : this.names) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (this.allowRestrictedIndices != null) {
            generator.writeKey("allow_restricted_indices");
            generator.write(this.allowRestrictedIndices.booleanValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSearchAccessDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fieldSecurity, FieldSecurity._DESERIALIZER, "field_security");
        op.add(Builder::names, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "names");
        op.add(Builder::query, IndicesPrivilegesQuery._DESERIALIZER, "query");
        op.add(Builder::allowRestrictedIndices, JsonpDeserializer.booleanDeserializer(), "allow_restricted_indices");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SearchAccess> {
        @Nullable
        private FieldSecurity fieldSecurity;
        private List<String> names;
        @Nullable
        private IndicesPrivilegesQuery query;
        @Nullable
        private Boolean allowRestrictedIndices;

        public Builder() {
        }

        private Builder(SearchAccess instance) {
            this.fieldSecurity = instance.fieldSecurity;
            this.names = instance.names;
            this.query = instance.query;
            this.allowRestrictedIndices = instance.allowRestrictedIndices;
        }

        public final Builder fieldSecurity(@Nullable FieldSecurity value) {
            this.fieldSecurity = value;
            return this;
        }

        public final Builder fieldSecurity(Function<FieldSecurity.Builder, ObjectBuilder<FieldSecurity>> fn) {
            return this.fieldSecurity(fn.apply(new FieldSecurity.Builder()).build());
        }

        public final Builder names(List<String> list) {
            this.names = Builder._listAddAll(this.names, list);
            return this;
        }

        public final Builder names(String value, String ... values) {
            this.names = Builder._listAdd(this.names, value, values);
            return this;
        }

        public final Builder query(@Nullable IndicesPrivilegesQuery value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<IndicesPrivilegesQuery.Builder, ObjectBuilder<IndicesPrivilegesQuery>> fn) {
            return this.query(fn.apply(new IndicesPrivilegesQuery.Builder()).build());
        }

        public final Builder allowRestrictedIndices(@Nullable Boolean value) {
            this.allowRestrictedIndices = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SearchAccess build() {
            this._checkSingleUse();
            return new SearchAccess(this);
        }
    }
}

