/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security.get_role;

import co.elastic.clients.elasticsearch.security.ApplicationPrivileges;
import co.elastic.clients.elasticsearch.security.ClusterPrivilege;
import co.elastic.clients.elasticsearch.security.IndicesPrivileges;
import co.elastic.clients.elasticsearch.security.RemoteClusterPrivileges;
import co.elastic.clients.elasticsearch.security.RemoteIndicesPrivileges;
import co.elastic.clients.elasticsearch.security.RoleTemplate;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Role
implements JsonpSerializable {
    private final List<String> cluster;
    private final List<IndicesPrivileges> indices;
    private final List<RemoteIndicesPrivileges> remoteIndices;
    private final List<RemoteClusterPrivileges> remoteCluster;
    private final Map<String, JsonData> metadata;
    @Nullable
    private final String description;
    private final List<String> runAs;
    private final Map<String, JsonData> transientMetadata;
    private final List<ApplicationPrivileges> applications;
    private final List<RoleTemplate> roleTemplates;
    private final Map<String, Map<String, Map<String, List<String>>>> global;
    public static final JsonpDeserializer<Role> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Role::setupRoleDeserializer);

    private Role(Builder builder) {
        this.cluster = ApiTypeHelper.unmodifiableRequired(builder.cluster, (Object)this, "cluster");
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
        this.remoteIndices = ApiTypeHelper.unmodifiable(builder.remoteIndices);
        this.remoteCluster = ApiTypeHelper.unmodifiable(builder.remoteCluster);
        this.metadata = ApiTypeHelper.unmodifiableRequired(builder.metadata, (Object)this, "metadata");
        this.description = builder.description;
        this.runAs = ApiTypeHelper.unmodifiable(builder.runAs);
        this.transientMetadata = ApiTypeHelper.unmodifiable(builder.transientMetadata);
        this.applications = ApiTypeHelper.unmodifiableRequired(builder.applications, (Object)this, "applications");
        this.roleTemplates = ApiTypeHelper.unmodifiable(builder.roleTemplates);
        this.global = ApiTypeHelper.unmodifiable(builder.global);
    }

    public static Role of(Function<Builder, ObjectBuilder<Role>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> cluster() {
        return this.cluster;
    }

    public final List<IndicesPrivileges> indices() {
        return this.indices;
    }

    public final List<RemoteIndicesPrivileges> remoteIndices() {
        return this.remoteIndices;
    }

    public final List<RemoteClusterPrivileges> remoteCluster() {
        return this.remoteCluster;
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    public final List<String> runAs() {
        return this.runAs;
    }

    public final Map<String, JsonData> transientMetadata() {
        return this.transientMetadata;
    }

    public final List<ApplicationPrivileges> applications() {
        return this.applications;
    }

    public final List<RoleTemplate> roleTemplates() {
        return this.roleTemplates;
    }

    public final Map<String, Map<String, Map<String, List<String>>>> global() {
        return this.global;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.cluster)) {
            generator.writeKey("cluster");
            generator.writeStartArray();
            for (String string : this.cluster) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (IndicesPrivileges indicesPrivileges : this.indices) {
                indicesPrivileges.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.remoteIndices)) {
            generator.writeKey("remote_indices");
            generator.writeStartArray();
            for (RemoteIndicesPrivileges remoteIndicesPrivileges : this.remoteIndices) {
                remoteIndicesPrivileges.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.remoteCluster)) {
            generator.writeKey("remote_cluster");
            generator.writeStartArray();
            for (RemoteClusterPrivileges remoteClusterPrivileges : this.remoteCluster) {
                remoteClusterPrivileges.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry entry : this.metadata.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (ApiTypeHelper.isDefined(this.runAs)) {
            generator.writeKey("run_as");
            generator.writeStartArray();
            for (String string : this.runAs) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.transientMetadata)) {
            generator.writeKey("transient_metadata");
            generator.writeStartObject();
            for (Map.Entry entry : this.transientMetadata.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.applications)) {
            generator.writeKey("applications");
            generator.writeStartArray();
            for (ApplicationPrivileges applicationPrivileges : this.applications) {
                applicationPrivileges.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.roleTemplates)) {
            generator.writeKey("role_templates");
            generator.writeStartArray();
            for (RoleTemplate roleTemplate : this.roleTemplates) {
                roleTemplate.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.global)) {
            generator.writeKey("global");
            generator.writeStartObject();
            for (Map.Entry entry : this.global.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.writeStartObject();
                if (entry.getValue() != null) {
                    for (Map.Entry item1 : ((Map)entry.getValue()).entrySet()) {
                        generator.writeKey((String)item1.getKey());
                        generator.writeStartObject();
                        if (item1.getValue() != null) {
                            for (Map.Entry item2 : ((Map)item1.getValue()).entrySet()) {
                                generator.writeKey((String)item2.getKey());
                                generator.writeStartArray();
                                if (item2.getValue() != null) {
                                    for (String item3 : (List)item2.getValue()) {
                                        generator.write(item3);
                                    }
                                }
                                generator.writeEnd();
                            }
                        }
                        generator.writeEnd();
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupRoleDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cluster, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "cluster");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(IndicesPrivileges._DESERIALIZER), "indices");
        op.add(Builder::remoteIndices, JsonpDeserializer.arrayDeserializer(RemoteIndicesPrivileges._DESERIALIZER), "remote_indices");
        op.add(Builder::remoteCluster, JsonpDeserializer.arrayDeserializer(RemoteClusterPrivileges._DESERIALIZER), "remote_cluster");
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::runAs, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "run_as");
        op.add(Builder::transientMetadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "transient_metadata");
        op.add(Builder::applications, JsonpDeserializer.arrayDeserializer(ApplicationPrivileges._DESERIALIZER), "applications");
        op.add(Builder::roleTemplates, JsonpDeserializer.arrayDeserializer(RoleTemplate._DESERIALIZER), "role_templates");
        op.add(Builder::global, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())))), "global");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Role> {
        private List<String> cluster;
        private List<IndicesPrivileges> indices;
        @Nullable
        private List<RemoteIndicesPrivileges> remoteIndices;
        @Nullable
        private List<RemoteClusterPrivileges> remoteCluster;
        private Map<String, JsonData> metadata;
        @Nullable
        private String description;
        @Nullable
        private List<String> runAs;
        @Nullable
        private Map<String, JsonData> transientMetadata;
        private List<ApplicationPrivileges> applications;
        @Nullable
        private List<RoleTemplate> roleTemplates;
        @Nullable
        private Map<String, Map<String, Map<String, List<String>>>> global;

        public Builder() {
        }

        private Builder(Role instance) {
            this.cluster = instance.cluster;
            this.indices = instance.indices;
            this.remoteIndices = instance.remoteIndices;
            this.remoteCluster = instance.remoteCluster;
            this.metadata = instance.metadata;
            this.description = instance.description;
            this.runAs = instance.runAs;
            this.transientMetadata = instance.transientMetadata;
            this.applications = instance.applications;
            this.roleTemplates = instance.roleTemplates;
            this.global = instance.global;
        }

        public final Builder cluster(List<String> list) {
            this.cluster = Builder._listAddAll(this.cluster, list);
            return this;
        }

        public final Builder cluster(String value, String ... values) {
            this.cluster = Builder._listAdd(this.cluster, value, values);
            return this;
        }

        public final Builder cluster(ClusterPrivilege value, ClusterPrivilege ... values) {
            this.cluster = Builder._listAdd(this.cluster, value.jsonValue(), (String[])Arrays.stream(values).map(ClusterPrivilege::jsonValue).toArray(String[]::new));
            return this;
        }

        public final Builder indices(List<IndicesPrivileges> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(IndicesPrivileges value, IndicesPrivileges ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder indices(Function<IndicesPrivileges.Builder, ObjectBuilder<IndicesPrivileges>> fn) {
            return this.indices(fn.apply(new IndicesPrivileges.Builder()).build(), new IndicesPrivileges[0]);
        }

        public final Builder remoteIndices(List<RemoteIndicesPrivileges> list) {
            this.remoteIndices = Builder._listAddAll(this.remoteIndices, list);
            return this;
        }

        public final Builder remoteIndices(RemoteIndicesPrivileges value, RemoteIndicesPrivileges ... values) {
            this.remoteIndices = Builder._listAdd(this.remoteIndices, value, values);
            return this;
        }

        public final Builder remoteIndices(Function<RemoteIndicesPrivileges.Builder, ObjectBuilder<RemoteIndicesPrivileges>> fn) {
            return this.remoteIndices(fn.apply(new RemoteIndicesPrivileges.Builder()).build(), new RemoteIndicesPrivileges[0]);
        }

        public final Builder remoteCluster(List<RemoteClusterPrivileges> list) {
            this.remoteCluster = Builder._listAddAll(this.remoteCluster, list);
            return this;
        }

        public final Builder remoteCluster(RemoteClusterPrivileges value, RemoteClusterPrivileges ... values) {
            this.remoteCluster = Builder._listAdd(this.remoteCluster, value, values);
            return this;
        }

        public final Builder remoteCluster(Function<RemoteClusterPrivileges.Builder, ObjectBuilder<RemoteClusterPrivileges>> fn) {
            return this.remoteCluster(fn.apply(new RemoteClusterPrivileges.Builder()).build(), new RemoteClusterPrivileges[0]);
        }

        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder runAs(List<String> list) {
            this.runAs = Builder._listAddAll(this.runAs, list);
            return this;
        }

        public final Builder runAs(String value, String ... values) {
            this.runAs = Builder._listAdd(this.runAs, value, values);
            return this;
        }

        public final Builder transientMetadata(Map<String, JsonData> map) {
            this.transientMetadata = Builder._mapPutAll(this.transientMetadata, map);
            return this;
        }

        public final Builder transientMetadata(String key, JsonData value) {
            this.transientMetadata = Builder._mapPut(this.transientMetadata, key, value);
            return this;
        }

        public final Builder applications(List<ApplicationPrivileges> list) {
            this.applications = Builder._listAddAll(this.applications, list);
            return this;
        }

        public final Builder applications(ApplicationPrivileges value, ApplicationPrivileges ... values) {
            this.applications = Builder._listAdd(this.applications, value, values);
            return this;
        }

        public final Builder applications(Function<ApplicationPrivileges.Builder, ObjectBuilder<ApplicationPrivileges>> fn) {
            return this.applications(fn.apply(new ApplicationPrivileges.Builder()).build(), new ApplicationPrivileges[0]);
        }

        public final Builder roleTemplates(List<RoleTemplate> list) {
            this.roleTemplates = Builder._listAddAll(this.roleTemplates, list);
            return this;
        }

        public final Builder roleTemplates(RoleTemplate value, RoleTemplate ... values) {
            this.roleTemplates = Builder._listAdd(this.roleTemplates, value, values);
            return this;
        }

        public final Builder roleTemplates(Function<RoleTemplate.Builder, ObjectBuilder<RoleTemplate>> fn) {
            return this.roleTemplates(fn.apply(new RoleTemplate.Builder()).build(), new RoleTemplate[0]);
        }

        public final Builder global(Map<String, Map<String, Map<String, List<String>>>> map) {
            this.global = Builder._mapPutAll(this.global, map);
            return this;
        }

        public final Builder global(String key, Map<String, Map<String, List<String>>> value) {
            this.global = Builder._mapPut(this.global, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Role build() {
            this._checkSingleUse();
            return new Role(this);
        }
    }
}

