/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class FileCountSnapshotStats
implements JsonpSerializable {
    private final int fileCount;
    private final long sizeInBytes;
    public static final JsonpDeserializer<FileCountSnapshotStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FileCountSnapshotStats::setupFileCountSnapshotStatsDeserializer);

    private FileCountSnapshotStats(Builder builder) {
        this.fileCount = ApiTypeHelper.requireNonNull(builder.fileCount, (Object)this, "fileCount", 0);
        this.sizeInBytes = ApiTypeHelper.requireNonNull(builder.sizeInBytes, (Object)this, "sizeInBytes", 0L);
    }

    public static FileCountSnapshotStats of(Function<Builder, ObjectBuilder<FileCountSnapshotStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int fileCount() {
        return this.fileCount;
    }

    public final long sizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("file_count");
        generator.write(this.fileCount);
        generator.writeKey("size_in_bytes");
        generator.write(this.sizeInBytes);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupFileCountSnapshotStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fileCount, JsonpDeserializer.integerDeserializer(), "file_count");
        op.add(Builder::sizeInBytes, JsonpDeserializer.longDeserializer(), "size_in_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FileCountSnapshotStats> {
        private Integer fileCount;
        private Long sizeInBytes;

        public Builder() {
        }

        private Builder(FileCountSnapshotStats instance) {
            this.fileCount = instance.fileCount;
            this.sizeInBytes = instance.sizeInBytes;
        }

        public final Builder fileCount(int value) {
            this.fileCount = value;
            return this;
        }

        public final Builder sizeInBytes(long value) {
            this.sizeInBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FileCountSnapshotStats build() {
            this._checkSingleUse();
            return new FileCountSnapshotStats(this);
        }
    }
}

