/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.snapshot.RepositoryAnalyzeResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class RepositoryAnalyzeRequest
extends RequestBase {
    @Nullable
    private final Integer blobCount;
    @Nullable
    private final Integer concurrency;
    @Nullable
    private final Boolean detailed;
    @Nullable
    private final Integer earlyReadNodeCount;
    @Nullable
    private final String maxBlobSize;
    @Nullable
    private final String maxTotalDataSize;
    private final String name;
    @Nullable
    private final Double rareActionProbability;
    @Nullable
    private final Boolean rarelyAbortWrites;
    @Nullable
    private final Integer readNodeCount;
    @Nullable
    private final Integer registerOperationCount;
    @Nullable
    private final Integer seed;
    @Nullable
    private final Time timeout;
    public static final Endpoint<RepositoryAnalyzeRequest, RepositoryAnalyzeResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<RepositoryAnalyzeRequest, RepositoryAnalyzeResponse>("es/snapshot.repository_analyze", request -> "POST", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_snapshot");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            buf.append("/_analyze");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("name", request.name);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.rareActionProbability != null) {
            params.put("rare_action_probability", String.valueOf(request.rareActionProbability));
        }
        if (request.seed != null) {
            params.put("seed", String.valueOf(request.seed));
        }
        if (request.detailed != null) {
            params.put("detailed", String.valueOf(request.detailed));
        }
        if (request.maxBlobSize != null) {
            params.put("max_blob_size", request.maxBlobSize);
        }
        if (request.earlyReadNodeCount != null) {
            params.put("early_read_node_count", String.valueOf(request.earlyReadNodeCount));
        }
        if (request.blobCount != null) {
            params.put("blob_count", String.valueOf(request.blobCount));
        }
        if (request.rarelyAbortWrites != null) {
            params.put("rarely_abort_writes", String.valueOf(request.rarelyAbortWrites));
        }
        if (request.maxTotalDataSize != null) {
            params.put("max_total_data_size", request.maxTotalDataSize);
        }
        if (request.readNodeCount != null) {
            params.put("read_node_count", String.valueOf(request.readNodeCount));
        }
        if (request.registerOperationCount != null) {
            params.put("register_operation_count", String.valueOf(request.registerOperationCount));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        if (request.concurrency != null) {
            params.put("concurrency", String.valueOf(request.concurrency));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, RepositoryAnalyzeResponse._DESERIALIZER);

    private RepositoryAnalyzeRequest(Builder builder) {
        this.blobCount = builder.blobCount;
        this.concurrency = builder.concurrency;
        this.detailed = builder.detailed;
        this.earlyReadNodeCount = builder.earlyReadNodeCount;
        this.maxBlobSize = builder.maxBlobSize;
        this.maxTotalDataSize = builder.maxTotalDataSize;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.rareActionProbability = builder.rareActionProbability;
        this.rarelyAbortWrites = builder.rarelyAbortWrites;
        this.readNodeCount = builder.readNodeCount;
        this.registerOperationCount = builder.registerOperationCount;
        this.seed = builder.seed;
        this.timeout = builder.timeout;
    }

    public static RepositoryAnalyzeRequest of(Function<Builder, ObjectBuilder<RepositoryAnalyzeRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer blobCount() {
        return this.blobCount;
    }

    @Nullable
    public final Integer concurrency() {
        return this.concurrency;
    }

    @Nullable
    public final Boolean detailed() {
        return this.detailed;
    }

    @Nullable
    public final Integer earlyReadNodeCount() {
        return this.earlyReadNodeCount;
    }

    @Nullable
    public final String maxBlobSize() {
        return this.maxBlobSize;
    }

    @Nullable
    public final String maxTotalDataSize() {
        return this.maxTotalDataSize;
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final Double rareActionProbability() {
        return this.rareActionProbability;
    }

    @Nullable
    public final Boolean rarelyAbortWrites() {
        return this.rarelyAbortWrites;
    }

    @Nullable
    public final Integer readNodeCount() {
        return this.readNodeCount;
    }

    @Nullable
    public final Integer registerOperationCount() {
        return this.registerOperationCount;
    }

    @Nullable
    public final Integer seed() {
        return this.seed;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RepositoryAnalyzeRequest> {
        @Nullable
        private Integer blobCount;
        @Nullable
        private Integer concurrency;
        @Nullable
        private Boolean detailed;
        @Nullable
        private Integer earlyReadNodeCount;
        @Nullable
        private String maxBlobSize;
        @Nullable
        private String maxTotalDataSize;
        private String name;
        @Nullable
        private Double rareActionProbability;
        @Nullable
        private Boolean rarelyAbortWrites;
        @Nullable
        private Integer readNodeCount;
        @Nullable
        private Integer registerOperationCount;
        @Nullable
        private Integer seed;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(RepositoryAnalyzeRequest instance) {
            this.blobCount = instance.blobCount;
            this.concurrency = instance.concurrency;
            this.detailed = instance.detailed;
            this.earlyReadNodeCount = instance.earlyReadNodeCount;
            this.maxBlobSize = instance.maxBlobSize;
            this.maxTotalDataSize = instance.maxTotalDataSize;
            this.name = instance.name;
            this.rareActionProbability = instance.rareActionProbability;
            this.rarelyAbortWrites = instance.rarelyAbortWrites;
            this.readNodeCount = instance.readNodeCount;
            this.registerOperationCount = instance.registerOperationCount;
            this.seed = instance.seed;
            this.timeout = instance.timeout;
        }

        public final Builder blobCount(@Nullable Integer value) {
            this.blobCount = value;
            return this;
        }

        public final Builder concurrency(@Nullable Integer value) {
            this.concurrency = value;
            return this;
        }

        public final Builder detailed(@Nullable Boolean value) {
            this.detailed = value;
            return this;
        }

        public final Builder earlyReadNodeCount(@Nullable Integer value) {
            this.earlyReadNodeCount = value;
            return this;
        }

        public final Builder maxBlobSize(@Nullable String value) {
            this.maxBlobSize = value;
            return this;
        }

        public final Builder maxTotalDataSize(@Nullable String value) {
            this.maxTotalDataSize = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder rareActionProbability(@Nullable Double value) {
            this.rareActionProbability = value;
            return this;
        }

        public final Builder rarelyAbortWrites(@Nullable Boolean value) {
            this.rarelyAbortWrites = value;
            return this;
        }

        public final Builder readNodeCount(@Nullable Integer value) {
            this.readNodeCount = value;
            return this;
        }

        public final Builder registerOperationCount(@Nullable Integer value) {
            this.registerOperationCount = value;
            return this;
        }

        public final Builder seed(@Nullable Integer value) {
            this.seed = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RepositoryAnalyzeRequest build() {
            this._checkSingleUse();
            return new RepositoryAnalyzeRequest(this);
        }
    }
}

