/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform.get_node_stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TransformSchedulerStats
implements JsonpSerializable {
    private final int registeredTransformCount;
    @Nullable
    private final String peekTransform;
    public static final JsonpDeserializer<TransformSchedulerStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TransformSchedulerStats::setupTransformSchedulerStatsDeserializer);

    private TransformSchedulerStats(Builder builder) {
        this.registeredTransformCount = ApiTypeHelper.requireNonNull(builder.registeredTransformCount, (Object)this, "registeredTransformCount", 0);
        this.peekTransform = builder.peekTransform;
    }

    public static TransformSchedulerStats of(Function<Builder, ObjectBuilder<TransformSchedulerStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int registeredTransformCount() {
        return this.registeredTransformCount;
    }

    @Nullable
    public final String peekTransform() {
        return this.peekTransform;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("registered_transform_count");
        generator.write(this.registeredTransformCount);
        if (this.peekTransform != null) {
            generator.writeKey("peek_transform");
            generator.write(this.peekTransform);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupTransformSchedulerStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::registeredTransformCount, JsonpDeserializer.integerDeserializer(), "registered_transform_count");
        op.add(Builder::peekTransform, JsonpDeserializer.stringDeserializer(), "peek_transform");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TransformSchedulerStats> {
        private Integer registeredTransformCount;
        @Nullable
        private String peekTransform;

        public Builder() {
        }

        private Builder(TransformSchedulerStats instance) {
            this.registeredTransformCount = instance.registeredTransformCount;
            this.peekTransform = instance.peekTransform;
        }

        public final Builder registeredTransformCount(int value) {
            this.registeredTransformCount = value;
            return this;
        }

        public final Builder peekTransform(@Nullable String value) {
            this.peekTransform = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TransformSchedulerStats build() {
            this._checkSingleUse();
            return new TransformSchedulerStats(this);
        }
    }
}

