/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.Schedule;
import co.elastic.clients.elasticsearch.watcher.ScheduleVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class HourlySchedule
implements ScheduleVariant,
JsonpSerializable {
    private final List<Integer> minute;
    public static final JsonpDeserializer<HourlySchedule> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HourlySchedule::setupHourlyScheduleDeserializer);

    private HourlySchedule(Builder builder) {
        this.minute = ApiTypeHelper.unmodifiableRequired(builder.minute, (Object)this, "minute");
    }

    public static HourlySchedule of(Function<Builder, ObjectBuilder<HourlySchedule>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Schedule.Kind _scheduleKind() {
        return Schedule.Kind.Hourly;
    }

    public final List<Integer> minute() {
        return this.minute;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.minute)) {
            generator.writeKey("minute");
            generator.writeStartArray();
            for (Integer item0 : this.minute) {
                generator.write(item0.intValue());
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupHourlyScheduleDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::minute, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.integerDeserializer()), "minute");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<HourlySchedule> {
        private List<Integer> minute;

        public Builder() {
        }

        private Builder(HourlySchedule instance) {
            this.minute = instance.minute;
        }

        public final Builder minute(List<Integer> list) {
            this.minute = Builder._listAddAll(this.minute, list);
            return this;
        }

        public final Builder minute(Integer value, Integer ... values) {
            this.minute = Builder._listAdd(this.minute, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HourlySchedule build() {
            this._checkSingleUse();
            return new HourlySchedule(this);
        }
    }
}

