/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.SlackMessage;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SlackAction
implements JsonpSerializable {
    @Nullable
    private final String account;
    private final SlackMessage message;
    public static final JsonpDeserializer<SlackAction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SlackAction::setupSlackActionDeserializer);

    private SlackAction(Builder builder) {
        this.account = builder.account;
        this.message = ApiTypeHelper.requireNonNull(builder.message, this, "message");
    }

    public static SlackAction of(Function<Builder, ObjectBuilder<SlackAction>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String account() {
        return this.account;
    }

    public final SlackMessage message() {
        return this.message;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.account != null) {
            generator.writeKey("account");
            generator.write(this.account);
        }
        generator.writeKey("message");
        this.message.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSlackActionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::account, JsonpDeserializer.stringDeserializer(), "account");
        op.add(Builder::message, SlackMessage._DESERIALIZER, "message");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SlackAction> {
        @Nullable
        private String account;
        private SlackMessage message;

        public Builder() {
        }

        private Builder(SlackAction instance) {
            this.account = instance.account;
            this.message = instance.message;
        }

        public final Builder account(@Nullable String value) {
            this.account = value;
            return this;
        }

        public final Builder message(SlackMessage value) {
            this.message = value;
            return this;
        }

        public final Builder message(Function<SlackMessage.Builder, ObjectBuilder<SlackMessage>> fn) {
            return this.message(fn.apply(new SlackMessage.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SlackAction build() {
            this._checkSingleUse();
            return new SlackAction(this);
        }
    }
}

