/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.rest5_client.low_level;

import co.elastic.clients.transport.rest5_client.low_level.LanguageRuntimeVersions;
import co.elastic.clients.transport.rest5_client.low_level.Node;
import co.elastic.clients.transport.rest5_client.low_level.NodeSelector;
import co.elastic.clients.transport.rest5_client.low_level.Rest5Client;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultAuthenticationStrategy;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.util.Timeout;
import org.apache.hc.core5.util.VersionInfo;

public final class Rest5ClientBuilder {
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 1000;
    public static final int DEFAULT_SOCKET_TIMEOUT_MILLIS = 30000;
    public static final int DEFAULT_RESPONSE_TIMEOUT_MILLIS = 0;
    public static final int DEFAULT_MAX_CONN_PER_ROUTE = 10;
    public static final int DEFAULT_MAX_CONN_TOTAL = 30;
    static final String THREAD_NAME_PREFIX = "elasticsearch-rest-client-";
    private static final String THREAD_NAME_FORMAT = "elasticsearch-rest-client-%d-thread-%d";
    public static final String VERSION;
    static final String META_HEADER_NAME = "X-Elastic-Client-Meta";
    static final String META_HEADER_VALUE;
    private static final String USER_AGENT_HEADER_VALUE;
    private static final Header[] EMPTY_HEADERS;
    private final List<Node> nodes;
    private CloseableHttpAsyncClient httpClient;
    private Consumer<HttpAsyncClientBuilder> httpClientConfigCallback;
    private Consumer<RequestConfig.Builder> requestConfigCallback;
    private Consumer<ConnectionConfig.Builder> connectionConfigCallback;
    private Consumer<PoolingAsyncClientConnectionManagerBuilder> connectionManagerCallback;
    private Header[] defaultHeaders = EMPTY_HEADERS;
    private Rest5Client.FailureListener failureListener;
    private SSLContext sslContext;
    private HttpHost proxy;
    private ProxySelector proxySelector;
    private HttpRoutePlanner routePlanner;
    private String pathPrefix;
    private NodeSelector nodeSelector = NodeSelector.ANY;
    private boolean strictDeprecationMode = false;
    private boolean compressionEnabled = false;
    private boolean metaHeaderEnabled = true;

    Rest5ClientBuilder(List<Node> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            throw new IllegalArgumentException("nodes must not be null or empty");
        }
        for (Node node : nodes) {
            if (node != null) continue;
            throw new IllegalArgumentException("node cannot be null");
        }
        this.nodes = nodes;
    }

    public Rest5ClientBuilder setHttpClient(CloseableHttpAsyncClient httpAsyncClient) {
        Objects.requireNonNull(httpAsyncClient, "custom rest client must not be null");
        this.httpClient = httpAsyncClient;
        return this;
    }

    public Rest5ClientBuilder setSSLContext(SSLContext sslContext) {
        Objects.requireNonNull(sslContext, "ssl context must not be null");
        this.sslContext = sslContext;
        return this;
    }

    public Rest5ClientBuilder setProxy(HttpHost proxy) {
        Objects.requireNonNull(proxy, "proxy must not be null");
        this.proxy = proxy;
        return this;
    }

    public Rest5ClientBuilder setProxySelector(ProxySelector proxySelector) {
        Objects.requireNonNull(proxySelector, "proxy selector must not be null");
        this.proxySelector = proxySelector;
        return this;
    }

    public Rest5ClientBuilder setRoutePlanner(HttpRoutePlanner routePlanner) {
        Objects.requireNonNull(routePlanner, "route planner must not be null");
        this.routePlanner = routePlanner;
        return this;
    }

    public Rest5ClientBuilder setDefaultHeaders(Header[] defaultHeaders) {
        Objects.requireNonNull(defaultHeaders, "defaultHeaders must not be null");
        for (Header defaultHeader : defaultHeaders) {
            Objects.requireNonNull(defaultHeader, "default header must not be null");
        }
        this.defaultHeaders = defaultHeaders;
        return this;
    }

    public Rest5ClientBuilder setFailureListener(Rest5Client.FailureListener failureListener) {
        Objects.requireNonNull(failureListener, "failureListener must not be null");
        this.failureListener = failureListener;
        return this;
    }

    public Rest5ClientBuilder setPathPrefix(String pathPrefix) {
        this.pathPrefix = Rest5ClientBuilder.cleanPathPrefix(pathPrefix);
        return this;
    }

    public static String cleanPathPrefix(String pathPrefix) {
        Objects.requireNonNull(pathPrefix, "pathPrefix must not be null");
        if (pathPrefix.isEmpty()) {
            throw new IllegalArgumentException("pathPrefix must not be empty");
        }
        Object cleanPathPrefix = pathPrefix;
        if (!((String)cleanPathPrefix).startsWith("/")) {
            cleanPathPrefix = "/" + (String)cleanPathPrefix;
        }
        if (((String)cleanPathPrefix).endsWith("/") && ((String)cleanPathPrefix).length() > 1 && ((String)(cleanPathPrefix = ((String)cleanPathPrefix).substring(0, ((String)cleanPathPrefix).length() - 1))).endsWith("/")) {
            throw new IllegalArgumentException("pathPrefix is malformed. too many trailing slashes: [" + pathPrefix + "]");
        }
        return cleanPathPrefix;
    }

    public Rest5ClientBuilder setNodeSelector(NodeSelector nodeSelector) {
        Objects.requireNonNull(nodeSelector, "nodeSelector must not be null");
        this.nodeSelector = nodeSelector;
        return this;
    }

    public Rest5ClientBuilder setStrictDeprecationMode(boolean strictDeprecationMode) {
        this.strictDeprecationMode = strictDeprecationMode;
        return this;
    }

    public Rest5ClientBuilder setCompressionEnabled(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
        return this;
    }

    public Rest5ClientBuilder setMetaHeaderEnabled(boolean metadataEnabled) {
        this.metaHeaderEnabled = metadataEnabled;
        return this;
    }

    public Rest5ClientBuilder setHttpClientConfigCallback(Consumer<HttpAsyncClientBuilder> httpClientConfigCallback) {
        Objects.requireNonNull(httpClientConfigCallback, "httpClientConfigCallback must not be null");
        this.httpClientConfigCallback = httpClientConfigCallback;
        return this;
    }

    public Rest5ClientBuilder setRequestConfigCallback(Consumer<RequestConfig.Builder> requestConfigCallback) {
        Objects.requireNonNull(requestConfigCallback, "requestConfigCallback must not be null");
        this.requestConfigCallback = requestConfigCallback;
        return this;
    }

    public Rest5ClientBuilder setConnectionConfigCallback(Consumer<ConnectionConfig.Builder> connectionConfigCallback) {
        Objects.requireNonNull(connectionConfigCallback, "connectionConfigCallback must not be null");
        this.connectionConfigCallback = connectionConfigCallback;
        return this;
    }

    public Rest5ClientBuilder setConnectionManagerCallback(Consumer<PoolingAsyncClientConnectionManagerBuilder> connectionManagerCallback) {
        Objects.requireNonNull(connectionManagerCallback, "connectionManagerCallback must not be null");
        this.connectionManagerCallback = connectionManagerCallback;
        return this;
    }

    public Rest5Client build() {
        if (this.failureListener == null) {
            this.failureListener = new Rest5Client.FailureListener();
        }
        CloseableHttpAsyncClient httpClient = this.createHttpClient();
        Rest5Client restClient = new Rest5Client(httpClient, this.defaultHeaders, this.nodes, this.pathPrefix, this.failureListener, this.nodeSelector, this.strictDeprecationMode, this.compressionEnabled, this.metaHeaderEnabled);
        httpClient.start();
        return restClient;
    }

    private CloseableHttpAsyncClient createHttpClient() {
        if (this.httpClient != null) {
            return this.httpClient;
        }
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectionRequestTimeout(Timeout.of((long)30000L, (TimeUnit)TimeUnit.MILLISECONDS)).setResponseTimeout(Timeout.of((long)0L, (TimeUnit)TimeUnit.MILLISECONDS));
        if (this.requestConfigCallback != null) {
            this.requestConfigCallback.accept(requestConfigBuilder);
        }
        try {
            SSLContext sslContext = this.sslContext != null ? this.sslContext : SSLContext.getDefault();
            ConnectionConfig.Builder connectionConfigBuilder = ConnectionConfig.custom().setConnectTimeout(Timeout.of((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS));
            if (this.connectionConfigCallback != null) {
                this.connectionConfigCallback.accept(connectionConfigBuilder);
            }
            PoolingAsyncClientConnectionManagerBuilder connectionManagerBuilder = PoolingAsyncClientConnectionManagerBuilder.create().setDefaultConnectionConfig(connectionConfigBuilder.build()).setMaxConnPerRoute(10).setMaxConnTotal(30).setTlsStrategy((TlsStrategy)new DefaultClientTlsStrategy(sslContext));
            if (this.connectionManagerCallback != null) {
                this.connectionManagerCallback.accept(connectionManagerBuilder);
            }
            HttpAsyncClientBuilder httpClientBuilder = HttpAsyncClientBuilder.create().setDefaultRequestConfig(requestConfigBuilder.build()).setConnectionManager((AsyncClientConnectionManager)connectionManagerBuilder.build()).setUserAgent(USER_AGENT_HEADER_VALUE).setTargetAuthenticationStrategy((AuthenticationStrategy)new DefaultAuthenticationStrategy()).setThreadFactory((ThreadFactory)new RestClientThreadFactory());
            if (this.proxy != null) {
                httpClientBuilder.setProxy(this.proxy);
            }
            if (this.proxySelector != null) {
                httpClientBuilder.setProxySelector(this.proxySelector);
            }
            if (this.routePlanner != null) {
                httpClientBuilder.setRoutePlanner(this.routePlanner);
            }
            if (this.httpClientConfigCallback != null) {
                this.httpClientConfigCallback.accept(httpClientBuilder);
            }
            return httpClientBuilder.build();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("could not create the default ssl context", e);
        }
    }

    static {
        EMPTY_HEADERS = new Header[0];
        String version = null;
        try (InputStream is2 = Rest5Client.class.getResourceAsStream("version.properties");){
            if (is2 != null) {
                Properties versions = new Properties();
                versions.load(is2);
                version = versions.getProperty("elasticsearch-client");
            }
        }
        catch (IOException is2) {
            // empty catch block
        }
        if (version == null) {
            version = "";
        }
        VERSION = version;
        USER_AGENT_HEADER_VALUE = String.format(Locale.ROOT, "elasticsearch-java/%s (Java/%s)", VERSION.isEmpty() ? "Unknown" : VERSION, System.getProperty("java.version"));
        VersionInfo httpClientVersion = null;
        try {
            httpClientVersion = VersionInfo.loadVersionInfo((String)"org.apache.hc.core5", (ClassLoader)HttpAsyncClientBuilder.class.getClassLoader());
        }
        catch (Exception versions) {
            // empty catch block
        }
        Object metaVersion = version;
        int dashPos = ((String)metaVersion).indexOf(45);
        if (dashPos > 0) {
            metaVersion = ((String)metaVersion).substring(0, dashPos) + "p";
        }
        META_HEADER_VALUE = "es=" + (String)metaVersion + ",jv=" + System.getProperty("java.specification.version") + ",t=" + (String)metaVersion + ",hc=" + (httpClientVersion == null ? "" : httpClientVersion.getRelease()) + LanguageRuntimeVersions.getRuntimeMetadata();
    }

    private static class RestClientThreadFactory
    implements ThreadFactory {
        private static final AtomicLong CLIENT_THREAD_POOL_ID_GENERATOR = new AtomicLong();
        private final long clientThreadPoolId = CLIENT_THREAD_POOL_ID_GENERATOR.getAndIncrement();
        private final AtomicLong clientThreadId = new AtomicLong();

        private RestClientThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, String.format(Locale.ROOT, Rest5ClientBuilder.THREAD_NAME_FORMAT, this.clientThreadPoolId, this.clientThreadId.incrementAndGet()));
        }
    }
}

