/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.rest5_client.low_level.sniffer;

import co.elastic.clients.transport.rest5_client.low_level.Node;
import co.elastic.clients.transport.rest5_client.low_level.Request;
import co.elastic.clients.transport.rest5_client.low_level.Response;
import co.elastic.clients.transport.rest5_client.low_level.Rest5Client;
import co.elastic.clients.transport.rest5_client.low_level.sniffer.NodesSniffer;
import jakarta.json.Json;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;

public final class ElasticsearchNodesSniffer
implements NodesSniffer {
    private static final Log logger = LogFactory.getLog(ElasticsearchNodesSniffer.class);
    public static final long DEFAULT_SNIFF_REQUEST_TIMEOUT = TimeUnit.SECONDS.toMillis(1L);
    private final Rest5Client restClient;
    private final Request request;
    private final Scheme scheme;
    private final JsonParserFactory jsonFactory = Json.createParserFactory(Map.of());

    public ElasticsearchNodesSniffer(Rest5Client restClient) {
        this(restClient, DEFAULT_SNIFF_REQUEST_TIMEOUT, Scheme.HTTP);
    }

    public ElasticsearchNodesSniffer(Rest5Client restClient, long sniffRequestTimeoutMillis, Scheme scheme) {
        this.restClient = Objects.requireNonNull(restClient, "restClient cannot be null");
        if (sniffRequestTimeoutMillis < 0L) {
            throw new IllegalArgumentException("sniffRequestTimeoutMillis must be greater than 0");
        }
        this.request = new Request("GET", "/_nodes/http");
        this.request.addParameter("timeout", sniffRequestTimeoutMillis + "ms");
        this.scheme = Objects.requireNonNull(scheme, "scheme cannot be null");
    }

    @Override
    public List<Node> sniff() throws IOException {
        Response response = this.restClient.performRequest(this.request);
        return ElasticsearchNodesSniffer.readHosts(response.getEntity(), this.scheme, this.jsonFactory);
    }

    static List<Node> readHosts(HttpEntity entity, Scheme scheme, JsonParserFactory jsonFactory) throws IOException {
        try (InputStream inputStream = entity.getContent();){
            JsonParser parser = jsonFactory.createParser(inputStream);
            if (parser.next() != JsonParser.Event.START_OBJECT) {
                throw new IOException("expected data to start with an object");
            }
            ArrayList<Node> nodes = new ArrayList<Node>();
            while (parser.next() != JsonParser.Event.END_OBJECT) {
                if (parser.currentEvent() == JsonParser.Event.KEY_NAME && "nodes".equals(parser.getString())) {
                    parser.next();
                    assert (parser.currentEvent() == JsonParser.Event.START_OBJECT);
                    while (parser.next() != JsonParser.Event.END_OBJECT) {
                        String nodeId = parser.getString();
                        Node node = ElasticsearchNodesSniffer.readNode(nodeId, parser, scheme);
                        if (node == null) continue;
                        nodes.add(node);
                    }
                    continue;
                }
                if (parser.currentEvent() != JsonParser.Event.START_OBJECT) continue;
                parser.skipObject();
            }
            ArrayList<Node> arrayList = nodes;
            return arrayList;
        }
    }

    private static Node readNode(String nodeId, JsonParser parser, Scheme scheme) throws IOException {
        HttpHost publishedHost = null;
        HashSet<HttpHost> boundHosts = new HashSet<HttpHost>();
        String name = null;
        String version = null;
        HashMap<String, String> protoAttributes = new HashMap<String, String>();
        boolean sawRoles = false;
        TreeSet<String> roles = new TreeSet<String>();
        String fieldName = null;
        while (parser.next() != JsonParser.Event.END_OBJECT) {
            if (parser.currentEvent() == JsonParser.Event.KEY_NAME) {
                fieldName = parser.getString();
                continue;
            }
            if (parser.currentEvent() == JsonParser.Event.START_OBJECT) {
                if ("http".equals(fieldName)) {
                    while (parser.next() != JsonParser.Event.END_OBJECT) {
                        if (parser.currentEvent() == JsonParser.Event.KEY_NAME && "publish_address".equals(parser.getString())) {
                            String host;
                            URI publishAddressAsURI;
                            parser.next();
                            String address = parser.getString();
                            if (address.contains("/")) {
                                String[] stringArray = address.split("/", 2);
                                publishAddressAsURI = URI.create(String.valueOf((Object)scheme) + "://" + stringArray[1]);
                                host = stringArray[0];
                            } else {
                                publishAddressAsURI = URI.create(String.valueOf((Object)scheme) + "://" + address);
                                host = publishAddressAsURI.getHost();
                            }
                            publishedHost = new HttpHost(publishAddressAsURI.getScheme(), host, publishAddressAsURI.getPort());
                            continue;
                        }
                        if (parser.currentEvent() == JsonParser.Event.KEY_NAME && "bound_address".equals(parser.getString())) {
                            parser.next();
                            assert (parser.currentEvent() == JsonParser.Event.START_ARRAY);
                            while (parser.next() != JsonParser.Event.END_ARRAY) {
                                URI boundAddressAsURI = URI.create(String.valueOf((Object)scheme) + "://" + parser.getString());
                                boundHosts.add(new HttpHost(boundAddressAsURI.getScheme(), boundAddressAsURI.getHost(), boundAddressAsURI.getPort()));
                            }
                            continue;
                        }
                        if (parser.currentEvent() != JsonParser.Event.START_OBJECT) continue;
                        parser.skipObject();
                    }
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    while (parser.next() != JsonParser.Event.END_OBJECT) {
                        if (parser.currentEvent() != JsonParser.Event.KEY_NAME) continue;
                        String key = parser.getString();
                        parser.next();
                        String value = parser.getString();
                        String oldValue = protoAttributes.put(key, value);
                        if (oldValue == null) continue;
                        throw new IOException("repeated attribute key [" + parser.currentEvent().name() + "]");
                    }
                    continue;
                }
                if (fieldName == null) continue;
                parser.skipObject();
                continue;
            }
            if (parser.currentEvent() == JsonParser.Event.START_ARRAY) {
                if ("roles".equals(fieldName)) {
                    sawRoles = true;
                    while (parser.next() != JsonParser.Event.END_ARRAY) {
                        roles.add(parser.getString());
                    }
                    continue;
                }
                parser.skipArray();
                continue;
            }
            if (!parser.currentEvent().name().equals(JsonParser.Event.VALUE_STRING.name())) continue;
            if ("version".equals(fieldName)) {
                version = parser.getString();
                continue;
            }
            if (!"name".equals(fieldName)) continue;
            name = parser.getString();
        }
        if (publishedHost == null) {
            logger.debug((Object)("skipping node [" + nodeId + "] with http disabled"));
            return null;
        }
        HashMap<String, List<String>> realAttributes = new HashMap<String, List<String>>(protoAttributes.size());
        ArrayList keys = new ArrayList(protoAttributes.keySet());
        for (String string : keys) {
            String value;
            if (!string.endsWith(".0")) continue;
            String realKey = string.substring(0, string.length() - 2);
            ArrayList<String> values = new ArrayList<String>();
            int i = 0;
            while ((value = (String)protoAttributes.remove(realKey + "." + i)) != null) {
                values.add(value);
                ++i;
            }
            realAttributes.put(realKey, Collections.unmodifiableList(values));
        }
        for (Map.Entry entry : protoAttributes.entrySet()) {
            realAttributes.put((String)entry.getKey(), Collections.singletonList((String)entry.getValue()));
        }
        if (version.startsWith("2.")) {
            boolean clientAttribute = ElasticsearchNodesSniffer.v2RoleAttributeValue(realAttributes, "client", false);
            Boolean bl = ElasticsearchNodesSniffer.v2RoleAttributeValue(realAttributes, "master", null);
            Boolean dataAttribute = ElasticsearchNodesSniffer.v2RoleAttributeValue(realAttributes, "data", null);
            if (bl == null && !clientAttribute || bl.booleanValue()) {
                roles.add("master");
            }
            if (dataAttribute == null && !clientAttribute || dataAttribute.booleanValue()) {
                roles.add("data");
            }
        } else assert (sawRoles) : "didn't see roles for [" + nodeId + "]";
        assert (boundHosts.contains(publishedHost)) : "[" + nodeId + "] doesn't make sense! publishedHost should be in boundHosts";
        logger.trace((Object)("adding node [" + nodeId + "]"));
        return new Node(publishedHost, boundHosts, name, version, new Node.Roles(roles), Collections.unmodifiableMap(realAttributes));
    }

    private static Boolean v2RoleAttributeValue(Map<String, List<String>> attributes, String name, Boolean defaultValue) throws IOException {
        List<String> valueList = attributes.remove(name);
        if (valueList == null) {
            return defaultValue;
        }
        if (valueList.size() != 1) {
            throw new IOException("expected only a single attribute value for [" + name + "] but got " + String.valueOf(valueList));
        }
        switch (valueList.get(0)) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        throw new IOException("expected [" + name + "] to be either [true] or [false] but was [" + valueList.get(0) + "]");
    }

    public static enum Scheme {
        HTTP("http"),
        HTTPS("https");

        private final String name;

        private Scheme(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

