/*
 * Decompiled with CFR 0.152.
 */
package co.helmethair.scalatest.runtime;

import co.helmethair.scalatest.descriptor.ScalatestEngineDescriptor;
import co.helmethair.scalatest.descriptor.ScalatestFailedInitDescriptor;
import co.helmethair.scalatest.descriptor.ScalatestSuiteDescriptor;
import co.helmethair.scalatest.descriptor.ScalatestTestDescriptor;
import co.helmethair.scalatest.scala.ScalaConversions;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestTag;
import org.scalatest.Suite;
import scala.Option;

public class Discovery {
    public ScalatestEngineDescriptor discover(ScalatestEngineDescriptor engineDescriptor, List<Class<? extends Suite>> classes, ClassLoader classLoader) {
        classes.forEach(c -> {
            try {
                Suite suite = (Suite)classLoader.loadClass(c.getName()).newInstance();
                this.addSuite(suite, (TestDescriptor)engineDescriptor);
            }
            catch (Throwable e) {
                this.addFailedInit(e, c.getName(), (TestDescriptor)engineDescriptor);
            }
        });
        return engineDescriptor;
    }

    private void addFailedInit(Throwable cause, String className, TestDescriptor parent) {
        ScalatestFailedInitDescriptor failed = new ScalatestFailedInitDescriptor(cause, className);
        this.linkChild(parent, failed);
    }

    private void addSuite(Suite suite, TestDescriptor parent) {
        ScalatestSuiteDescriptor scalatestSuiteDescriptor = new ScalatestSuiteDescriptor(suite, suite.suiteId(), suite.suiteName());
        this.linkChild(parent, scalatestSuiteDescriptor);
        this.addTests(scalatestSuiteDescriptor, ScalaConversions.setAsJavaSet(suite.testNames()));
        ScalaConversions.asJavaCollection(suite.nestedSuites()).forEach(scalatestNestedSuite -> {
            try {
                this.addSuite((Suite)scalatestNestedSuite, scalatestSuiteDescriptor);
            }
            catch (Throwable e) {
                this.addFailedInit(e, scalatestNestedSuite.getClass().getName(), scalatestSuiteDescriptor);
            }
        });
    }

    private void linkChild(TestDescriptor parent, TestDescriptor child) {
        child.setParent(parent);
        parent.addChild(child);
    }

    private void addTests(ScalatestSuiteDescriptor suite, Set<String> testNames) {
        testNames.forEach(testName -> this.linkChild(suite, new ScalatestTestDescriptor(suite, (String)testName, this.getTags(suite.getScalasuite(), (String)testName))));
    }

    private Set<TestTag> getTags(Suite scalasuite, String testName) {
        Option tagSetOption = scalasuite.tags().get((Object)testName);
        if (tagSetOption.isDefined()) {
            return ScalaConversions.setAsJavaSet((scala.collection.immutable.Set)tagSetOption.get()).stream().map(TestTag::create).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }
}

