/*
 * Decompiled with CFR 0.152.
 */
package co.helmethair.scalatest.descriptor;

import co.helmethair.scalatest.descriptor.ScalatestDescriptor;
import co.helmethair.scalatest.descriptor.ScalatestSuiteDescriptor;
import java.util.Optional;
import java.util.Set;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.support.descriptor.MethodSource;

public class ScalatestTestDescriptor
extends ScalatestDescriptor {
    private final ScalatestSuiteDescriptor containingSuite;
    private final String testName;
    private final Set<TestTag> tags;
    private final Optional<TestSource> source;

    public ScalatestTestDescriptor(ScalatestSuiteDescriptor containingSuite, String testName, Set<TestTag> tags) {
        super(ScalatestTestDescriptor.testId(containingSuite.getSuiteId(), testName));
        this.containingSuite = containingSuite;
        this.testName = testName;
        this.tags = tags;
        this.source = Optional.of(MethodSource.from((String)containingSuite.getSuiteId(), (String)testName, (String)""));
    }

    public String getDisplayName() {
        return this.testName;
    }

    public Optional<TestSource> getSource() {
        return this.source;
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }

    public String getTestName() {
        return this.testName;
    }

    @Override
    public Set<TestTag> getTags() {
        return this.tags;
    }

    public ScalatestSuiteDescriptor getContainingSuite() {
        return this.containingSuite;
    }
}

