/*
 * Decompiled with CFR 0.152.
 */
package co.nstant.in.cbor.encoder;

import co.nstant.in.cbor.CborEncoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.encoder.AbstractEncoder;
import co.nstant.in.cbor.model.MajorType;
import co.nstant.in.cbor.model.NegativeInteger;
import java.io.OutputStream;
import java.math.BigInteger;

public class NegativeIntegerEncoder
extends AbstractEncoder<NegativeInteger> {
    private static final BigInteger MINUS_ONE = BigInteger.valueOf(-1L);

    public NegativeIntegerEncoder(CborEncoder encoder, OutputStream outputStream) {
        super(encoder, outputStream);
    }

    @Override
    public void encode(NegativeInteger dataItem) throws CborException {
        this.encodeTypeAndLength(MajorType.NEGATIVE_INTEGER, MINUS_ONE.subtract(dataItem.getValue()).abs());
    }
}

