/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.chain;

import com.agentsflex.core.chain.Chain;
import com.agentsflex.core.chain.ChainEdge;
import com.agentsflex.core.chain.ChainNodeStatus;
import com.agentsflex.core.chain.NodeCondition;
import com.agentsflex.core.chain.Parameter;
import com.agentsflex.core.memory.ContextMemory;
import com.agentsflex.core.memory.DefaultContextMemory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class ChainNode
implements Serializable {
    protected String id;
    protected String name;
    protected String description;
    protected boolean async = false;
    protected List<ChainEdge> inwardEdges;
    protected List<ChainEdge> outwardEdges;
    protected NodeCondition condition;
    protected ContextMemory memory = new DefaultContextMemory();
    protected ChainNodeStatus nodeStatus = ChainNodeStatus.READY;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public List<ChainEdge> getInwardEdges() {
        return this.inwardEdges;
    }

    public void setInwardEdges(List<ChainEdge> inwardEdges) {
        this.inwardEdges = inwardEdges;
    }

    public List<ChainEdge> getOutwardEdges() {
        return this.outwardEdges;
    }

    public void setOutwardEdges(List<ChainEdge> outwardEdges) {
        this.outwardEdges = outwardEdges;
    }

    public NodeCondition getCondition() {
        return this.condition;
    }

    public void setCondition(NodeCondition condition) {
        this.condition = condition;
    }

    public ContextMemory getMemory() {
        return this.memory;
    }

    public void setMemory(ContextMemory memory) {
        this.memory = memory;
    }

    public ChainNodeStatus getNodeStatus() {
        return this.nodeStatus;
    }

    public void setNodeStatus(ChainNodeStatus nodeStatus) {
        this.nodeStatus = nodeStatus;
    }

    protected void addOutwardEdge(ChainEdge edge) {
        if (this.outwardEdges == null) {
            this.outwardEdges = new ArrayList<ChainEdge>();
        }
        this.outwardEdges.add(edge);
    }

    protected void addInwardEdge(ChainEdge edge) {
        if (this.inwardEdges == null) {
            this.inwardEdges = new ArrayList<ChainEdge>();
        }
        this.inwardEdges.add(edge);
    }

    protected abstract Map<String, Object> execute(Chain var1);

    public List<Parameter> getParameters() {
        return null;
    }
}

