/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.llm.functions;

import com.agentsflex.core.convert.ConvertService;
import com.agentsflex.core.llm.functions.BaseFunction;
import com.agentsflex.core.llm.functions.JavaNativeParameter;
import com.agentsflex.core.llm.functions.annotation.FunctionDef;
import com.agentsflex.core.llm.functions.annotation.FunctionParam;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JavaNativeFunction
extends BaseFunction {
    private Class<?> clazz;
    private Object object;
    private Method method;

    public Class<?> getClazz() {
        return this.clazz;
    }

    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        Parameter[] methodParameters;
        this.method = method;
        FunctionDef functionDef = method.getAnnotation(FunctionDef.class);
        this.name = functionDef.name();
        this.description = functionDef.description();
        ArrayList<JavaNativeParameter> parameterList = new ArrayList<JavaNativeParameter>();
        for (Parameter methodParameter : methodParameters = method.getParameters()) {
            JavaNativeParameter parameter = JavaNativeFunction.getParameter(methodParameter);
            parameterList.add(parameter);
        }
        this.parameters = parameterList.toArray(new JavaNativeParameter[0]);
    }

    @NotNull
    private static JavaNativeParameter getParameter(Parameter methodParameter) {
        FunctionParam functionParam = methodParameter.getAnnotation(FunctionParam.class);
        JavaNativeParameter parameter = new JavaNativeParameter();
        parameter.setName(functionParam.name());
        parameter.setDescription(functionParam.description());
        parameter.setType(methodParameter.getType().getSimpleName().toLowerCase());
        parameter.setTypeClass(methodParameter.getType());
        parameter.setRequired(functionParam.required());
        parameter.setEnums(functionParam.enums());
        return parameter;
    }

    @Override
    public Object invoke(Map<String, Object> argsMap) {
        try {
            Object[] args = new Object[this.parameters.length];
            for (int i = 0; i < this.parameters.length; ++i) {
                JavaNativeParameter parameter = (JavaNativeParameter)this.parameters[i];
                Object value = argsMap.get(parameter.getName());
                args[i] = ConvertService.convert(value, parameter.getTypeClass());
            }
            return this.method.invoke(this.object, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

