/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.prompt;

import com.agentsflex.core.llm.response.AiMessageResponse;
import com.agentsflex.core.llm.response.FunctionCaller;
import com.agentsflex.core.message.Message;
import com.agentsflex.core.message.ToolMessage;
import com.agentsflex.core.prompt.HistoriesPrompt;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.util.StringUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;

public class ToolPrompt
extends Prompt {
    private List<Message> messages;

    public static ToolPrompt of(AiMessageResponse response) {
        return ToolPrompt.of(response, null);
    }

    public static ToolPrompt of(AiMessageResponse response, HistoriesPrompt withHistories) {
        Object object;
        List<FunctionCaller> functionCallers = response.getFunctionCallers();
        FunctionCaller functionCaller = functionCallers.get(0);
        ToolMessage toolMessage = new ToolMessage();
        toolMessage.setToolCallId(functionCaller.getFunctionCall().getId());
        if (StringUtil.noText(toolMessage.getToolCallId())) {
            toolMessage.setToolCallId(functionCaller.getFunctionCall().getName());
        }
        if ((object = functionCaller.call()) instanceof CharSequence || object instanceof Number) {
            toolMessage.setContent(object.toString());
        } else {
            toolMessage.setContent(JSON.toJSONString((Object)object));
        }
        if (withHistories != null) {
            withHistories.addMessages(response.getPrompt().toMessages());
            withHistories.addMessage(response.getMessage());
            withHistories.addMessage(toolMessage);
            return new HistoriesToolPrompt(withHistories);
        }
        ToolPrompt toolPrompt = new ToolPrompt();
        toolPrompt.messages = new ArrayList<Message>();
        toolPrompt.messages.addAll(response.getPrompt().toMessages());
        toolPrompt.messages.add(response.getMessage());
        toolPrompt.messages.add(toolMessage);
        return toolPrompt;
    }

    @Override
    public List<Message> toMessages() {
        return this.messages;
    }

    static class HistoriesToolPrompt
    extends ToolPrompt {
        HistoriesPrompt historiesPrompt;

        public HistoriesToolPrompt(HistoriesPrompt historiesPrompt) {
            this.historiesPrompt = historiesPrompt;
        }

        @Override
        public List<Message> toMessages() {
            return this.historiesPrompt.toMessages();
        }
    }
}

