/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public class ClassUtil {
    private static final String[] OBJECT_METHODS = new String[]{"toString", "getClass", "equals", "hashCode", "wait", "notify", "notifyAll", "clone", "finalize"};
    private static final List<String> PROXY_CLASS_NAMES = Arrays.asList("net.sf.cglib.proxy.Factory", "org.springframework.cglib.proxy.Factory", "javassist.util.proxy.ProxyObject", "org.apache.ibatis.javassist.util.proxy.ProxyObject");
    private static final String ENHANCER_BY = "$$EnhancerBy";
    private static final String JAVASSIST_BY = "_$$_";

    private ClassUtil() {
    }

    public static boolean isProxy(Class<?> clazz) {
        for (Class<?> cls : clazz.getInterfaces()) {
            if (!PROXY_CLASS_NAMES.contains(cls.getName())) continue;
            return true;
        }
        return Proxy.isProxyClass(clazz);
    }

    private static <T> Class<T> getJdkProxySuperClass(Class<T> clazz) {
        Class<?> proxyClass = Proxy.getProxyClass(clazz.getClassLoader(), clazz.getInterfaces());
        return proxyClass.getInterfaces()[0];
    }

    public static <T> Class<T> getUsefulClass(Class<T> clazz) {
        if (ClassUtil.isProxy(clazz)) {
            return ClassUtil.getJdkProxySuperClass(clazz);
        }
        String name = clazz.getName();
        if (name.contains(ENHANCER_BY) || name.contains(JAVASSIST_BY)) {
            return clazz.getSuperclass();
        }
        return clazz;
    }

    public static Class<?> getWrapType(Class<?> clazz) {
        if (clazz == null || !clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Void.TYPE) {
            return Void.class;
        }
        return clazz;
    }

    public static boolean isArray(Class<?> clazz) {
        return clazz.isArray() || clazz == int[].class || clazz == long[].class || clazz == short[].class || clazz == float[].class || clazz == double[].class;
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ClassUtil.doGetFields(clazz, fields, null, false);
        return fields;
    }

    public static List<Field> getAllFields(Class<?> clazz, Predicate<Field> predicate) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ClassUtil.doGetFields(clazz, fields, predicate, false);
        return fields;
    }

    public static Field getFirstField(Class<?> clazz, Predicate<Field> predicate) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ClassUtil.doGetFields(clazz, fields, predicate, true);
        return fields.isEmpty() ? null : (Field)fields.get(0);
    }

    private static void doGetFields(Class<?> clazz, List<Field> fields, Predicate<Field> predicate, boolean firstOnly) {
        Field[] declaredFields;
        if (clazz == null || clazz == Object.class) {
            return;
        }
        for (Field declaredField : declaredFields = clazz.getDeclaredFields()) {
            if (predicate != null && !predicate.test(declaredField)) continue;
            fields.add(declaredField);
            if (firstOnly) break;
        }
        if (firstOnly && !fields.isEmpty()) {
            return;
        }
        ClassUtil.doGetFields(clazz.getSuperclass(), fields, predicate, firstOnly);
    }

    public static List<Method> getAllMethods(Class<?> clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        ClassUtil.doGetMethods(clazz, methods, null, false);
        return methods;
    }

    public static List<Method> getAllMethods(Class<?> clazz, Predicate<Method> predicate) {
        ArrayList<Method> methods = new ArrayList<Method>();
        ClassUtil.doGetMethods(clazz, methods, predicate, false);
        return methods;
    }

    public static Method getFirstMethod(Class<?> clazz, Predicate<Method> predicate) {
        ArrayList<Method> methods = new ArrayList<Method>();
        ClassUtil.doGetMethods(clazz, methods, predicate, true);
        return methods.isEmpty() ? null : (Method)methods.get(0);
    }

    private static void doGetMethods(Class<?> clazz, List<Method> methods, Predicate<Method> predicate, boolean firstOnly) {
        Method[] declaredMethods;
        if (clazz == null || clazz == Object.class) {
            return;
        }
        for (Method method : declaredMethods = clazz.getDeclaredMethods()) {
            if (predicate != null && !predicate.test(method)) continue;
            methods.add(method);
            if (firstOnly) break;
        }
        if (firstOnly && !methods.isEmpty()) {
            return;
        }
        ClassUtil.doGetMethods(clazz.getSuperclass(), methods, predicate, firstOnly);
    }
}

