/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.config;

import com.alicp.jetcache.anno.aop.CacheAdvisor;
import com.alicp.jetcache.anno.aop.JetCacheInterceptor;
import com.alicp.jetcache.anno.support.ConfigMap;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.aop.config.AopNamespaceUtils;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class CacheAnnotationParser
implements BeanDefinitionParser {
    private final ReentrantLock reentrantLock = new ReentrantLock();

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        this.reentrantLock.lock();
        try {
            this.doParse(element, parserContext);
        }
        finally {
            this.reentrantLock.unlock();
        }
        return null;
    }

    private void doParse(Element element, ParserContext parserContext) {
        String[] basePackages = StringUtils.tokenizeToStringArray((String)element.getAttribute("base-package"), (String)",; \t\n");
        AopNamespaceUtils.registerAutoProxyCreatorIfNecessary((ParserContext)parserContext, (Element)element);
        if (!parserContext.getRegistry().containsBeanDefinition("jetcache2.internalCacheAdvisor")) {
            Object eleSource = parserContext.extractSource((Object)element);
            RootBeanDefinition configMapDef = new RootBeanDefinition(ConfigMap.class);
            configMapDef.setSource(eleSource);
            configMapDef.setRole(2);
            String configMapName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)configMapDef);
            RootBeanDefinition interceptorDef = new RootBeanDefinition(JetCacheInterceptor.class);
            interceptorDef.setSource(eleSource);
            interceptorDef.setRole(2);
            interceptorDef.getPropertyValues().addPropertyValue(new PropertyValue("cacheConfigMap", (Object)new RuntimeBeanReference(configMapName)));
            String interceptorName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)interceptorDef);
            RootBeanDefinition advisorDef = new RootBeanDefinition(CacheAdvisor.class);
            advisorDef.setSource(eleSource);
            advisorDef.setRole(2);
            advisorDef.getPropertyValues().addPropertyValue(new PropertyValue("adviceBeanName", (Object)interceptorName));
            advisorDef.getPropertyValues().addPropertyValue(new PropertyValue("cacheConfigMap", (Object)new RuntimeBeanReference(configMapName)));
            advisorDef.getPropertyValues().addPropertyValue(new PropertyValue("basePackages", (Object)basePackages));
            parserContext.getRegistry().registerBeanDefinition("jetcache2.internalCacheAdvisor", (BeanDefinition)advisorDef);
            CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), eleSource);
            compositeDef.addNestedComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)configMapDef, configMapName));
            compositeDef.addNestedComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)interceptorDef, interceptorName));
            compositeDef.addNestedComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)advisorDef, "jetcache2.internalCacheAdvisor"));
            parserContext.registerComponent((ComponentDefinition)compositeDef);
        }
    }
}

