/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.easysdk.base.video;

import com.alipay.easysdk.base.video.models.AlipayOfflineMaterialImageUploadResponse;
import com.aliyun.tea.Tea;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaException;
import com.aliyun.tea.TeaModel;
import com.aliyun.tea.TeaPair;
import com.aliyun.tea.TeaRequest;
import com.aliyun.tea.TeaResponse;
import com.aliyun.tea.TeaUnretryableException;
import java.util.HashMap;
import java.util.Map;

public class Client {
    public com.alipay.easysdk.kernel.Client _kernel;

    public Client(com.alipay.easysdk.kernel.Client kernel) throws Exception {
        this._kernel = kernel;
    }

    public AlipayOfflineMaterialImageUploadResponse upload(String videoName, String videoFilePath) throws Exception {
        Map<String, Object> runtime_ = TeaConverter.buildMap(new TeaPair("connectTimeout", 100000), new TeaPair("readTimeout", 100000), new TeaPair("retry", TeaConverter.buildMap(new TeaPair("maxAttempts", 0))));
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)runtime_.get("retry"), _retryTimes, _now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), _retryTimes)) > 0) {
                Tea.sleep(backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                Map<String, String> systemParams = TeaConverter.buildMap(new TeaPair("method", "alipay.offline.material.image.upload"), new TeaPair("app_id", this._kernel.getConfig("appId")), new TeaPair("timestamp", this._kernel.getTimestamp()), new TeaPair("format", "json"), new TeaPair("version", "1.0"), new TeaPair("alipay_sdk", this._kernel.getSdkVersion()), new TeaPair("charset", "UTF-8"), new TeaPair("sign_type", this._kernel.getConfig("signType")), new TeaPair("app_cert_sn", this._kernel.getMerchantCertSN()), new TeaPair("alipay_root_cert_sn", this._kernel.getAlipayRootCertSN()));
                HashMap bizParams = new HashMap();
                Map<String, String> textParams = TeaConverter.buildMap(new TeaPair("image_type", "mp4"), new TeaPair("image_name", videoName));
                Map<String, String> fileParams = TeaConverter.buildMap(new TeaPair("image_content", videoFilePath));
                String boundary = this._kernel.getRandomBoundary();
                request_.protocol = this._kernel.getConfig("protocol");
                request_.method = "POST";
                request_.pathname = "/gateway.do";
                request_.headers = TeaConverter.buildMap(new TeaPair("host", this._kernel.getConfig("gatewayHost")), new TeaPair("content-type", this._kernel.concatStr("multipart/form-data;charset=utf-8;boundary=", boundary)));
                request_.query = this._kernel.sortMap(TeaConverter.merge(String.class, TeaConverter.buildMap(new TeaPair("sign", this._kernel.sign(systemParams, bizParams, textParams, this._kernel.getConfig("merchantPrivateKey")))), systemParams));
                request_.body = this._kernel.toMultipartRequestBody(textParams, fileParams, boundary);
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction(request_, runtime_);
                Map<String, Object> respMap = this._kernel.readAsJson(response_, "alipay.offline.material.image.upload");
                if (this._kernel.isCertMode() != false ? this._kernel.verify(respMap, this._kernel.extractAlipayPublicKey(this._kernel.getAlipayCertSN(respMap))) != false : this._kernel.verify(respMap, this._kernel.getConfig("alipayPublicKey")) != false) {
                    return TeaModel.toModel(this._kernel.toRespModel(respMap), new AlipayOfflineMaterialImageUploadResponse());
                }
                throw new TeaException(TeaConverter.buildMap(new TeaPair("message", "\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u652f\u4ed8\u5b9d\u516c\u94a5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002")));
            }
            catch (Exception e) {
                if (Tea.isRetryable(e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public Client agent(String appAuthToken) {
        this._kernel.injectTextParam("app_auth_token", appAuthToken);
        return this;
    }

    public Client auth(String authToken) {
        this._kernel.injectTextParam("auth_token", authToken);
        return this;
    }

    public Client asyncNotify(String url) {
        this._kernel.injectTextParam("notify_url", url);
        return this;
    }

    public Client route(String testUrl) {
        this._kernel.injectTextParam("ws_service_url", testUrl);
        return this;
    }

    public Client optional(String key, Object value) {
        this._kernel.injectBizParam(key, value);
        return this;
    }

    public Client batchOptional(Map<String, Object> optionalArgs) {
        for (Map.Entry<String, Object> pair : optionalArgs.entrySet()) {
            this._kernel.injectBizParam(pair.getKey(), pair.getValue());
        }
        return this;
    }
}

