/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.easysdk.kernel.util;

import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntCertificationUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(AntCertificationUtil.class);
    private static BouncyCastleProvider provider = new BouncyCastleProvider();

    public static boolean isTrusted(String certContent, String rootCertContent) {
        X509Certificate[] certificates;
        try {
            certificates = AntCertificationUtil.readPemCertChain(certContent);
        }
        catch (Exception e) {
            LOGGER.error("\u8bfb\u53d6\u8bc1\u4e66\u5931\u8d25", e);
            throw new RuntimeException(e);
        }
        ArrayList<X509Certificate> rootCerts = new ArrayList<X509Certificate>();
        try {
            X509Certificate[] certs = AntCertificationUtil.readPemCertChain(rootCertContent);
            rootCerts.addAll(Arrays.asList(certs));
        }
        catch (Exception e) {
            LOGGER.error("\u8bfb\u53d6\u6839\u8bc1\u4e66\u5931\u8d25", e);
            throw new RuntimeException(e);
        }
        return AntCertificationUtil.verifyCertChain(certificates, rootCerts.toArray(new X509Certificate[rootCerts.size()]));
    }

    private static boolean verifyCert(X509Certificate cert, X509Certificate[] rootCerts) {
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException e) {
            LOGGER.error("\u8bc1\u4e66\u5df2\u7ecf\u8fc7\u671f", e);
            return false;
        }
        catch (CertificateNotYetValidException e) {
            LOGGER.error("\u8bc1\u4e66\u672a\u6fc0\u6d3b", e);
            return false;
        }
        HashMap<Principal, X509Certificate> subjectMap = new HashMap<Principal, X509Certificate>();
        for (X509Certificate root : rootCerts) {
            subjectMap.put(root.getSubjectDN(), root);
        }
        Principal issuerDN = cert.getIssuerDN();
        X509Certificate issuer = (X509Certificate)subjectMap.get(issuerDN);
        if (issuer == null) {
            LOGGER.error("\u8bc1\u4e66\u94fe\u9a8c\u8bc1\u5931\u8d25");
            return false;
        }
        try {
            PublicKey publicKey = issuer.getPublicKey();
            AntCertificationUtil.verifySignature(publicKey, cert);
        }
        catch (Exception e) {
            LOGGER.error("\u8bc1\u4e66\u94fe\u9a8c\u8bc1\u5931\u8d25", e);
            return false;
        }
        return true;
    }

    private static boolean verifyCertChain(X509Certificate[] certs, X509Certificate[] rootCerts) {
        boolean sorted2 = AntCertificationUtil.sortByDn(certs);
        if (!sorted2) {
            LOGGER.error("\u8bc1\u4e66\u94fe\u9a8c\u8bc1\u5931\u8d25\uff1a\u4e0d\u662f\u5b8c\u6574\u7684\u8bc1\u4e66\u94fe");
            return false;
        }
        X509Certificate prev = certs[0];
        boolean firstOK = AntCertificationUtil.verifyCert(prev, rootCerts);
        if (!firstOK || certs.length == 1) {
            return firstOK;
        }
        for (int i = 1; i < certs.length; ++i) {
            try {
                X509Certificate cert = certs[i];
                try {
                    cert.checkValidity();
                }
                catch (CertificateExpiredException e) {
                    LOGGER.error("\u8bc1\u4e66\u5df2\u7ecf\u8fc7\u671f");
                    return false;
                }
                catch (CertificateNotYetValidException e) {
                    LOGGER.error("\u8bc1\u4e66\u672a\u6fc0\u6d3b");
                    return false;
                }
                AntCertificationUtil.verifySignature(prev.getPublicKey(), cert);
                prev = cert;
                continue;
            }
            catch (Exception e) {
                LOGGER.error("\u8bc1\u4e66\u94fe\u9a8c\u8bc1\u5931\u8d25");
                return false;
            }
        }
        return true;
    }

    private static void verifySignature(PublicKey publicKey, X509Certificate cert) throws NoSuchProviderException, CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        cert.verify(publicKey, provider.getName());
    }

    private static boolean sortByDn(X509Certificate[] certs) {
        HashMap<Principal, X509Certificate> subjectMap = new HashMap<Principal, X509Certificate>();
        HashMap<Principal, X509Certificate> issuerMap = new HashMap<Principal, X509Certificate>();
        boolean hasSelfSignedCert = false;
        for (X509Certificate cert : certs) {
            if (AntCertificationUtil.isSelfSigned(cert)) {
                if (hasSelfSignedCert) {
                    return false;
                }
                hasSelfSignedCert = true;
            }
            Principal subjectDN = cert.getSubjectDN();
            Principal issuerDN = cert.getIssuerDN();
            subjectMap.put(subjectDN, cert);
            issuerMap.put(issuerDN, cert);
        }
        ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
        X509Certificate current = certs[0];
        AntCertificationUtil.addressingUp(subjectMap, certChain, current);
        AntCertificationUtil.addressingDown(issuerMap, certChain, current);
        if (certs.length != certChain.size()) {
            return false;
        }
        for (int i = 0; i < certChain.size(); ++i) {
            certs[i] = (X509Certificate)certChain.get(i);
        }
        return true;
    }

    private static boolean isSelfSigned(X509Certificate cert) {
        return cert.getSubjectDN().equals(cert.getIssuerDN());
    }

    private static void addressingUp(Map<Principal, X509Certificate> subjectMap, List<X509Certificate> certChain, X509Certificate current) {
        certChain.add(0, current);
        if (AntCertificationUtil.isSelfSigned(current)) {
            return;
        }
        Principal issuerDN = current.getIssuerDN();
        X509Certificate issuer = subjectMap.get(issuerDN);
        if (issuer == null) {
            return;
        }
        AntCertificationUtil.addressingUp(subjectMap, certChain, issuer);
    }

    private static void addressingDown(Map<Principal, X509Certificate> issuerMap, List<X509Certificate> certChain, X509Certificate current) {
        Principal subjectDN = current.getSubjectDN();
        X509Certificate subject = issuerMap.get(subjectDN);
        if (subject == null) {
            return;
        }
        if (AntCertificationUtil.isSelfSigned(subject)) {
            return;
        }
        certChain.add(subject);
        AntCertificationUtil.addressingDown(issuerMap, certChain, subject);
    }

    private static X509Certificate[] readPemCertChain(String cert) throws CertificateException {
        ByteArrayInputStream inputStream2 = new ByteArrayInputStream(cert.getBytes());
        CertificateFactory factory = CertificateFactory.getInstance("X.509", provider);
        Collection<? extends Certificate> certificates = factory.generateCertificates(inputStream2);
        return certificates.toArray(new X509Certificate[certificates.size()]);
    }

    public static String getRootCertSN(String rootCertContent) {
        String rootCertSN = null;
        try {
            X509Certificate[] x509Certificates = AntCertificationUtil.readPemCertChain(rootCertContent);
            MessageDigest md = MessageDigest.getInstance("MD5");
            for (X509Certificate c : x509Certificates) {
                if (!c.getSigAlgOID().startsWith("1.2.840.113549.1.1")) continue;
                md.update((c.getIssuerX500Principal().getName() + c.getSerialNumber()).getBytes());
                String certSN = new BigInteger(1, md.digest()).toString(16);
                certSN = AntCertificationUtil.fillMD5(certSN);
                rootCertSN = Strings.isNullOrEmpty(rootCertSN) ? certSN : rootCertSN + "_" + certSN;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u63d0\u53d6\u6839\u8bc1\u4e66\u5931\u8d25");
        }
        return rootCertSN;
    }

    public static String getCertSN(String certContent) {
        try {
            ByteArrayInputStream inputStream2 = new ByteArrayInputStream(certContent.getBytes());
            CertificateFactory factory = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate cert = (X509Certificate)factory.generateCertificate(inputStream2);
            return AntCertificationUtil.md5((cert.getIssuerX500Principal().getName() + cert.getSerialNumber()).getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static String md5(byte[] bytes) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(bytes);
        String certSN = new BigInteger(1, md.digest()).toString(16);
        certSN = AntCertificationUtil.fillMD5(certSN);
        return certSN;
    }

    private static String fillMD5(String md5) {
        return md5.length() == 32 ? md5 : AntCertificationUtil.fillMD5("0" + md5);
    }

    public static String getCertPublicKey(String certContent) {
        try {
            ByteArrayInputStream inputStream2 = new ByteArrayInputStream(certContent.getBytes());
            CertificateFactory factory = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate cert = (X509Certificate)factory.generateCertificate(inputStream2);
            return Base64.toBase64String(cert.getPublicKey().getEncoded());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String readCertContent(String certPath) {
        if (AntCertificationUtil.existsInFileSystem(certPath)) {
            return AntCertificationUtil.readFromFileSystem(certPath);
        }
        return AntCertificationUtil.readFromClassPath(certPath);
    }

    private static boolean existsInFileSystem(String certPath) {
        try {
            return new File(certPath).exists();
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static String readFromFileSystem(String certPath) {
        try {
            return new String(Files.toByteArray(new File(certPath)), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("\u4ece\u6587\u4ef6\u7cfb\u7edf\u4e2d\u8bfb\u53d6[" + certPath + "]\u5931\u8d25\uff0c" + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readFromClassPath(String certPath) {
        try (InputStream inputStream2 = Thread.currentThread().getContextClassLoader().getResourceAsStream(certPath);){
            String string = new String(ByteStreams.toByteArray(inputStream2), StandardCharsets.UTF_8);
            return string;
        }
        catch (Exception e) {
            String errorMessage = e.getMessage() == null ? "" : e.getMessage() + "\u3002";
            if (!certPath.startsWith("/")) throw new RuntimeException("\u8bfb\u53d6[" + certPath + "]\u5931\u8d25\u3002" + errorMessage, e);
            errorMessage = errorMessage + "ClassPath\u8def\u5f84\u4e0d\u53ef\u4ee5/\u5f00\u5934\uff0c\u8bf7\u53bb\u9664\u540e\u91cd\u8bd5\u3002";
            throw new RuntimeException("\u8bfb\u53d6[" + certPath + "]\u5931\u8d25\u3002" + errorMessage, e);
        }
    }

    static {
        Security.addProvider(provider);
    }
}

