/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tea;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import kotlin.Pair;
import okhttp3.Response;

public class TeaResponse {
    public Response response;
    public int statusCode;
    public String statusMessage;
    public HashMap<String, String> headers = new HashMap();
    public InputStream body;

    public TeaResponse() {
    }

    public TeaResponse(Response response) {
        this.response = response;
        this.statusCode = response.code();
        this.statusMessage = response.message();
        this.body = response.body().byteStream();
        for (Pair<String, String> pair : response.headers()) {
            this.headers.put(pair.getFirst(), pair.getSecond());
        }
    }

    public InputStream getResponse() throws IOException {
        return this.body;
    }

    public String getResponseBody() throws IOException {
        int read;
        if (null == this.body) {
            return String.format("{\"message\":\"%s\"}", this.statusMessage);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buff = new byte[4096];
        while ((read = this.body.read(buff)) != -1) {
            os.write(buff, 0, read);
        }
        return new String(os.toByteArray());
    }
}

