/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tea.okhttp;

import com.aliyun.tea.TeaRequest;
import com.aliyun.tea.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OkRequestBody
extends RequestBody {
    private InputStream inputStream;
    private String contentType;

    public OkRequestBody(TeaRequest teaRequest) {
        this.inputStream = teaRequest.body;
        this.contentType = teaRequest.headers.get("content-type");
    }

    @Override
    @Nullable
    public MediaType contentType() {
        if (StringUtils.isEmpty(this.contentType)) {
            MediaType type = MediaType.parse("application/json; charset=UTF-8;");
            return type;
        }
        return MediaType.parse(this.contentType);
    }

    @Override
    public long contentLength() throws IOException {
        if (null != this.inputStream && this.inputStream.available() > 0) {
            return this.inputStream.available();
        }
        return super.contentLength();
    }

    @Override
    public void writeTo(@NotNull BufferedSink bufferedSink) throws IOException {
        int bytesRead;
        if (null == this.inputStream) {
            return;
        }
        byte[] buffer = new byte[4096];
        while ((bytesRead = this.inputStream.read(buffer)) != -1) {
            bufferedSink.write(buffer, 0, bytesRead);
        }
    }
}

