/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.credentials.provider;

import com.aliyun.credentials.Configuration;
import com.aliyun.credentials.exception.CredentialException;
import com.aliyun.credentials.http.CompatibleUrlConnClient;
import com.aliyun.credentials.http.HttpRequest;
import com.aliyun.credentials.http.HttpResponse;
import com.aliyun.credentials.http.MethodType;
import com.aliyun.credentials.models.Config;
import com.aliyun.credentials.models.CredentialModel;
import com.aliyun.credentials.provider.AlibabaCloudCredentialsProvider;
import com.aliyun.credentials.provider.RefreshResult;
import com.aliyun.credentials.provider.SessionCredentialsProvider;
import com.aliyun.credentials.provider.StaticCredentialsProvider;
import com.aliyun.credentials.utils.AuthUtils;
import com.aliyun.credentials.utils.ParameterHelper;
import com.aliyun.credentials.utils.StringUtils;
import com.aliyun.tea.utils.Validate;
import com.google.gson.Gson;
import java.util.Map;

public class RamRoleArnCredentialProvider
extends SessionCredentialsProvider {
    public int durationSeconds = 3600;
    private String roleArn;
    private String roleSessionName = "javaSdkRoleSessionName";
    private final AlibabaCloudCredentialsProvider credentialsProvider;
    private String regionId = "cn-hangzhou";
    private String policy;
    private int connectTimeout = 10000;
    private int readTimeout = 5000;
    private String STSEndpoint = "sts.aliyuncs.com";
    private String externalId;

    @Deprecated
    public RamRoleArnCredentialProvider(Configuration config) {
        this(config.getAccessKeyId(), config.getAccessKeySecret(), config.getRoleArn());
        this.roleSessionName = config.getRoleSessionName();
        this.connectTimeout = config.getConnectTimeout();
        this.readTimeout = config.getReadTimeout();
        if (!StringUtils.isEmpty(config.getSTSEndpoint())) {
            this.STSEndpoint = config.getSTSEndpoint();
        }
    }

    @Deprecated
    public RamRoleArnCredentialProvider(Config config) {
        this(config.accessKeyId, config.accessKeySecret, config.roleArn);
        this.roleSessionName = config.roleSessionName;
        this.connectTimeout = config.connectTimeout;
        this.readTimeout = config.timeout;
        this.policy = config.policy;
        this.durationSeconds = config.roleSessionExpiration;
        if (!StringUtils.isEmpty(config.STSEndpoint)) {
            this.STSEndpoint = config.STSEndpoint;
        }
    }

    @Deprecated
    public RamRoleArnCredentialProvider(String accessKeyId, String accessKeySecret, String roleArn) {
        super(new BuilderImpl());
        this.roleArn = roleArn;
        this.credentialsProvider = StaticCredentialsProvider.builder().credential(CredentialModel.builder().accessKeyId(accessKeyId).accessKeySecret(accessKeySecret).type("access_key").providerName("static_ak").build()).build();
    }

    @Deprecated
    public RamRoleArnCredentialProvider(String accessKeyId, String accessKeySecret, String roleSessionName, String roleArn, String regionId, String policy) {
        this(accessKeyId, accessKeySecret, roleArn);
        this.roleSessionName = roleSessionName;
        this.regionId = regionId;
        this.policy = policy;
    }

    private RamRoleArnCredentialProvider(BuilderImpl builder) {
        super(builder);
        this.roleSessionName = builder.roleSessionName == null ? (!StringUtils.isEmpty(AuthUtils.getEnvironmentRoleSessionName()) ? AuthUtils.getEnvironmentRoleSessionName() : "credentials-java-" + System.currentTimeMillis()) : builder.roleSessionName;
        int n = this.durationSeconds = builder.durationSeconds == null ? 3600 : builder.durationSeconds;
        if (this.durationSeconds < 900) {
            throw new IllegalArgumentException("Session duration should be in the range of 900s - max session duration.");
        }
        String string = this.roleArn = builder.roleArn == null ? AuthUtils.getEnvironmentRoleArn() : builder.roleArn;
        if (StringUtils.isEmpty(this.roleArn)) {
            throw new IllegalArgumentException("RoleArn or environment variable ALIBABA_CLOUD_ROLE_ARN cannot be empty.");
        }
        this.regionId = builder.regionId;
        this.policy = builder.policy;
        this.externalId = builder.externalId;
        this.connectTimeout = builder.connectionTimeout == null ? 5000 : builder.connectionTimeout;
        int n2 = this.readTimeout = builder.readTimeout == null ? 10000 : builder.readTimeout;
        if (!StringUtils.isEmpty(builder.STSEndpoint)) {
            this.STSEndpoint = builder.STSEndpoint;
        } else {
            String prefix;
            String string2 = builder.enableVpc != null ? (builder.enableVpc.booleanValue() ? "sts-vpc" : "sts") : (prefix = AuthUtils.isEnableVpcEndpoint() ? "sts-vpc" : "sts");
            this.STSEndpoint = !StringUtils.isEmpty(builder.stsRegionId) ? String.format("%s.%s.aliyuncs.com", prefix, builder.stsRegionId) : (!StringUtils.isEmpty(AuthUtils.getEnvironmentSTSRegion()) ? String.format("%s.%s.aliyuncs.com", prefix, AuthUtils.getEnvironmentSTSRegion()) : "sts.aliyuncs.com");
        }
        this.credentialsProvider = null != builder.credentialsProvider ? builder.credentialsProvider : (!StringUtils.isEmpty(builder.securityToken) ? StaticCredentialsProvider.builder().credential(CredentialModel.builder().accessKeyId((String)Validate.notNull((Object)builder.accessKeyId, (String)"AccessKeyId must not be null.", (Object[])new Object[0])).accessKeySecret((String)Validate.notNull((Object)builder.accessKeySecret, (String)"AccessKeySecret must not be null.", (Object[])new Object[0])).securityToken((String)Validate.notNull((Object)builder.securityToken, (String)"SecurityToken must not be null.", (Object[])new Object[0])).type("sts").providerName("static_sts").build()).build() : StaticCredentialsProvider.builder().credential(CredentialModel.builder().accessKeyId((String)Validate.notNull((Object)builder.accessKeyId, (String)"AccessKeyId must not be null.", (Object[])new Object[0])).accessKeySecret((String)Validate.notNull((Object)builder.accessKeySecret, (String)"AccessKeySecret must not be null.", (Object[])new Object[0])).type("access_key").providerName("static_ak").build()).build());
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public RefreshResult<CredentialModel> refreshCredentials() {
        try (CompatibleUrlConnClient client = new CompatibleUrlConnClient();){
            RefreshResult<CredentialModel> refreshResult = this.createCredential(client);
            return refreshResult;
        }
    }

    public RefreshResult<CredentialModel> createCredential(CompatibleUrlConnClient client) {
        return this.getNewSessionCredentials(client);
    }

    public RefreshResult<CredentialModel> getNewSessionCredentials(CompatibleUrlConnClient client) {
        HttpResponse httpResponse;
        ParameterHelper parameterHelper = new ParameterHelper();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrlParameter("Action", "AssumeRole");
        httpRequest.setUrlParameter("Format", "JSON");
        httpRequest.setUrlParameter("Version", "2015-04-01");
        httpRequest.setUrlParameter("DurationSeconds", String.valueOf(this.durationSeconds));
        httpRequest.setUrlParameter("RoleArn", this.roleArn);
        httpRequest.setUrlParameter("RoleSessionName", this.roleSessionName);
        if (this.policy != null) {
            httpRequest.setUrlParameter("Policy", this.policy);
        }
        if (this.externalId != null) {
            httpRequest.setUrlParameter("ExternalId", this.externalId);
        }
        httpRequest.setSysMethod(MethodType.GET);
        httpRequest.setSysConnectTimeout(this.connectTimeout);
        httpRequest.setSysReadTimeout(this.readTimeout);
        CredentialModel credentials = this.credentialsProvider.getCredentials();
        Validate.notNull((Object)credentials, (String)"Unable to load original credentials from the providers in RAM role arn.", (Object[])new Object[0]);
        httpRequest.setUrlParameter("AccessKeyId", credentials.getAccessKeyId());
        if (!StringUtils.isEmpty(credentials.getSecurityToken())) {
            httpRequest.setUrlParameter("SecurityToken", credentials.getSecurityToken());
        }
        String strToSign = parameterHelper.composeStringToSign(MethodType.GET, httpRequest.getUrlParameters());
        String signature = parameterHelper.signString(strToSign, credentials.getAccessKeySecret() + "&");
        httpRequest.setUrlParameter("Signature", signature);
        httpRequest.setSysUrl(parameterHelper.composeUrl(this.STSEndpoint, httpRequest.getUrlParameters(), "https"));
        try {
            httpResponse = client.syncInvoke(httpRequest);
        }
        catch (Exception e) {
            throw new CredentialException("Failed to connect RamRoleArn Service: " + e);
        }
        if (httpResponse.getResponseCode() != 200) {
            throw new CredentialException(String.format("Error refreshing credentials from RamRoleArn, HttpCode: %s, result: %s.", httpResponse.getResponseCode(), httpResponse.getHttpContentString()));
        }
        Gson gson = new Gson();
        Map map = (Map)gson.fromJson(httpResponse.getHttpContentString(), Map.class);
        if (null == map || !map.containsKey("Credentials")) {
            throw new CredentialException(String.format("Error retrieving credentials from RamRoleArn result: %s.", httpResponse.getHttpContentString()));
        }
        Map result = (Map)map.get("Credentials");
        if (!(result.containsKey("AccessKeyId") && result.containsKey("AccessKeySecret") && result.containsKey("SecurityToken"))) {
            throw new CredentialException(String.format("Error retrieving credentials from RamRoleArn result: %s.", httpResponse.getHttpContentString()));
        }
        long expiration = ParameterHelper.getUTCDate((String)result.get("Expiration")).getTime();
        CredentialModel credential = CredentialModel.builder().accessKeyId((String)result.get("AccessKeyId")).accessKeySecret((String)result.get("AccessKeySecret")).securityToken((String)result.get("SecurityToken")).type("ram_role_arn").providerName(String.format("%s/%s", this.getProviderName(), credentials.getProviderName())).expiration(expiration).build();
        return RefreshResult.builder(credential).staleTime(this.getStaleTime(expiration)).build();
    }

    public int getDurationSeconds() {
        return this.durationSeconds;
    }

    public void setDurationSeconds(int durationSeconds) {
        this.durationSeconds = durationSeconds;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public String getRoleSessionName() {
        return this.roleSessionName;
    }

    public void setRoleSessionName(String roleSessionName) {
        this.roleSessionName = roleSessionName;
    }

    private AlibabaCloudCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public String getAccessKeyId() {
        return this.credentialsProvider.getCredentials().getAccessKeyId();
    }

    public void setAccessKeyId(String accessKeyId) {
        CredentialModel credentialModel = this.credentialsProvider.getCredentials();
        credentialModel.setAccessKeyId(accessKeyId);
    }

    public String getAccessKeySecret() {
        return this.credentialsProvider.getCredentials().getAccessKeySecret();
    }

    public void setAccessKeySecret(String accessKeySecret) {
        CredentialModel credentialModel = this.credentialsProvider.getCredentials();
        credentialModel.setAccessKeySecret(accessKeySecret);
    }

    public String getRegionId() {
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getSTSEndpoint() {
        return this.STSEndpoint;
    }

    public void setSTSEndpoint(String STSEndpoint) {
        this.STSEndpoint = STSEndpoint;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public String getProviderName() {
        return "ram_role_arn";
    }

    @Override
    public void close() {
        super.close();
    }

    private static final class BuilderImpl
    extends SessionCredentialsProvider.BuilderImpl<RamRoleArnCredentialProvider, Builder>
    implements Builder {
        private String roleSessionName;
        private Integer durationSeconds;
        private String roleArn;
        private String regionId;
        private String policy;
        private Integer connectionTimeout;
        private Integer readTimeout;
        private String STSEndpoint;
        private String stsRegionId;
        private Boolean enableVpc;
        private String accessKeyId;
        private String accessKeySecret;
        private String securityToken;
        private AlibabaCloudCredentialsProvider credentialsProvider;
        private String externalId;

        private BuilderImpl() {
        }

        @Override
        public Builder roleSessionName(String roleSessionName) {
            this.roleSessionName = roleSessionName;
            return this;
        }

        @Override
        public Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        @Override
        public Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder regionId(String regionId) {
            this.regionId = regionId;
            return this;
        }

        @Override
        public Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public Builder connectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        @Override
        public Builder readTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        @Override
        public Builder STSEndpoint(String STSEndpoint) {
            this.STSEndpoint = STSEndpoint;
            return this;
        }

        @Override
        public Builder stsRegionId(String stsRegionId) {
            this.stsRegionId = stsRegionId;
            return this;
        }

        @Override
        public Builder enableVpc(Boolean enableVpc) {
            this.enableVpc = enableVpc;
            return this;
        }

        @Override
        public Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        @Override
        public Builder accessKeySecret(String accessKeySecret) {
            this.accessKeySecret = accessKeySecret;
            return this;
        }

        @Override
        public Builder securityToken(String securityToken) {
            this.securityToken = securityToken;
            return this;
        }

        @Override
        public Builder credentialsProvider(AlibabaCloudCredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        @Override
        public Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        @Override
        public RamRoleArnCredentialProvider build() {
            return new RamRoleArnCredentialProvider(this);
        }
    }

    public static interface Builder
    extends SessionCredentialsProvider.Builder<RamRoleArnCredentialProvider, Builder> {
        public Builder roleSessionName(String var1);

        public Builder durationSeconds(Integer var1);

        public Builder roleArn(String var1);

        public Builder regionId(String var1);

        public Builder policy(String var1);

        public Builder connectionTimeout(Integer var1);

        public Builder readTimeout(Integer var1);

        public Builder STSEndpoint(String var1);

        public Builder stsRegionId(String var1);

        public Builder enableVpc(Boolean var1);

        public Builder accessKeyId(String var1);

        public Builder accessKeySecret(String var1);

        public Builder securityToken(String var1);

        public Builder credentialsProvider(AlibabaCloudCredentialsProvider var1);

        public Builder externalId(String var1);

        @Override
        public RamRoleArnCredentialProvider build();
    }
}

