/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.data;

import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.utils.StringUtils;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class TableInfo {
    public static final String DEFAULT_LABEL = "__default__";
    public static final String INNER_OUTPUT_LABEL = "INNER_OUTPUT";
    private String projectName;
    private String tblName;
    private LinkedHashMap<String, String> partSpec = new LinkedHashMap();
    private String[] cols;
    private String label = "__default__";
    private String mapperClassName;
    private static final transient String SEPERATOR = "/";
    private static final transient String DELIMITER = "=";

    public TableInfo(String projectName, String tblName, LinkedHashMap<String, String> partSpec, String[] cols, String lable) {
        this.projectName = projectName;
        this.tblName = tblName;
        this.partSpec = partSpec;
        this.cols = cols;
        this.label = lable;
        this.validate();
    }

    public TableInfo() {
    }

    public TableInfo(TableInfo table) {
        this(table.projectName, table.tblName, table.partSpec, table.cols, table.label);
        this.mapperClassName = table.mapperClassName;
    }

    public static TableInfoBuilder builder() {
        return new TableInfoBuilder();
    }

    public void validate() {
        if (this.tblName == null || this.tblName.trim().isEmpty()) {
            throw new RuntimeException("ODPS-0730001: table should not be null or empty: " + this.tblName);
        }
    }

    public String getProjectName() {
        return this.projectName;
    }

    public PartitionSpec getPartitionSpec() {
        PartitionSpec partitionSpec = new PartitionSpec();
        for (String key : this.partSpec.keySet()) {
            partitionSpec.set(key, this.partSpec.get(key));
        }
        return partitionSpec;
    }

    public LinkedHashMap<String, String> getPartSpec() {
        return this.partSpec;
    }

    public String getPartPath() {
        StringBuilder sb = new StringBuilder();
        if (this.partSpec != null) {
            for (Map.Entry<String, String> e : this.partSpec.entrySet()) {
                sb.append(e.getKey()).append(DELIMITER).append(e.getValue()).append(SEPERATOR);
            }
        }
        return sb.toString();
    }

    public void setPartSpec(LinkedHashMap<String, String> partSpec) {
        this.partSpec = partSpec;
    }

    public void setPartSpec(String partPath) {
        this.partSpec = this.getPartSpecFromPath(partPath);
    }

    public String[] getCols() {
        return this.cols;
    }

    public void setCols(String[] cols) {
        this.cols = cols;
    }

    public String getTableName() {
        return this.tblName;
    }

    public void setTableName(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new RuntimeException("ODPS-0730001: table should not be null or empty: " + name);
        }
        String[] ss = StringUtils.splitPreserveAllTokens(name.trim(), '.');
        if (ss.length == 2) {
            if (ss[0].trim().isEmpty() || ss[1].trim().isEmpty()) {
                throw new RuntimeException("ODPS-0730001: error table format: " + name);
            }
            this.projectName = ss[0];
            this.tblName = ss[1];
        } else if (ss.length == 1) {
            if (ss[0].trim().isEmpty()) {
                throw new RuntimeException("ODPS-0730001: error table format: " + name);
            }
            this.tblName = ss[0];
        } else {
            throw new RuntimeException("ODPS-0730001: error table format: " + name);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLable(String lable) {
        this.label = lable;
    }

    public Class<?> getMapperClass() {
        if (StringUtils.isEmpty(this.mapperClassName)) {
            return null;
        }
        Class<?> mapperClass = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            mapperClass = Class.forName(this.mapperClassName, false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("ODPS-0730001: ClassNotFoundException - " + e.getMessage());
        }
        return mapperClass;
    }

    public void setMapperClass(Class<?> mapperClass) {
        this.mapperClassName = mapperClass.getName();
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public boolean equals(Object that) {
        if (!(that instanceof TableInfo)) {
            return false;
        }
        TableInfo t = (TableInfo)that;
        return TableInfo.stringEquals(this.projectName, t.projectName) && TableInfo.stringEquals(this.tblName, t.tblName) && Arrays.equals(this.cols, t.cols) && TableInfo.stringEquals(this.label, t.label) && this.partSpec.equals(t.partSpec);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.projectName != null) {
            sb.append(this.projectName).append('.');
        }
        sb.append(this.tblName);
        if (this.partSpec != null && !this.partSpec.isEmpty()) {
            sb.append(this.partSpec.toString());
        }
        return sb.toString();
    }

    private static boolean stringEquals(String cs1, String cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        return cs1.equals(cs2);
    }

    private LinkedHashMap<String, String> getPartSpecFromPath(String path) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (path != null && !path.trim().isEmpty()) {
            String[] parts;
            for (String part : parts = path.split(SEPERATOR)) {
                String[] ss = part.split(DELIMITER);
                if (ss.length != 2) {
                    throw new RuntimeException("ODPS-0730001: error part spec format: " + path);
                }
                map.put(ss[0], ss[1]);
            }
        }
        return map;
    }

    public static class TableInfoBuilder {
        private TableInfo table = new TableInfo();

        public TableInfoBuilder projectName(String projectName) {
            this.table.setProjectName(projectName);
            return this;
        }

        public TableInfoBuilder mapperClass(Class mapperClass) {
            this.table.setMapperClass(mapperClass);
            return this;
        }

        public TableInfoBuilder tableName(String tblName) {
            this.table.setTableName(tblName);
            return this;
        }

        public TableInfoBuilder partSpec(LinkedHashMap<String, String> partSpec) {
            this.table.setPartSpec(partSpec);
            return this;
        }

        public TableInfoBuilder partSpec(PartitionSpec partSpec) {
            if (partSpec != null && !partSpec.isEmpty()) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                for (String key : partSpec.keys()) {
                    map.put(key, partSpec.get(key));
                }
                this.table.setPartSpec(map);
            }
            return this;
        }

        public TableInfoBuilder partSpec(String partPath) {
            this.table.setPartSpec(partPath);
            return this;
        }

        public TableInfoBuilder cols(String[] cols) {
            this.table.setCols(cols);
            return this;
        }

        public TableInfoBuilder label(String label) {
            this.table.setLable(label);
            return this;
        }

        public TableInfo build() {
            return new TableInfo(this.table);
        }
    }
}

