/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.condition;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.protocol.OTSProtocolBuilder;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.condition.ColumnCondition;
import com.alicloud.openservices.tablestore.model.condition.ColumnConditionType;
import com.alicloud.openservices.tablestore.model.filter.SingleColumnValueFilter;
import com.google.protobuf.ByteString;

public class SingleColumnValueCondition
implements ColumnCondition {
    private CompareOperator operator;
    private String columnName;
    private ColumnValue columnValue;
    private boolean passIfMissing = true;
    private boolean latestVersionsOnly = true;

    public SingleColumnValueCondition(String columnName, CompareOperator operator, ColumnValue columnValue) {
        this.setColumnName(columnName);
        this.setOperator(operator);
        this.setColumnValue(columnValue);
    }

    public CompareOperator getOperator() {
        return this.operator;
    }

    public SingleColumnValueCondition setOperator(CompareOperator operator) {
        Preconditions.checkNotNull(operator, "The operator should not be null.");
        this.operator = operator;
        return this;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public SingleColumnValueCondition setColumnName(String columnName) {
        Preconditions.checkArgument(columnName != null && !columnName.isEmpty(), "The name of column should not be null or empty.");
        this.columnName = columnName;
        return this;
    }

    public ColumnValue getColumnValue() {
        return this.columnValue;
    }

    public SingleColumnValueCondition setColumnValue(ColumnValue columnValue) {
        Preconditions.checkNotNull(columnValue, "The value of column should not be null.");
        this.columnValue = columnValue;
        return this;
    }

    public boolean isPassIfMissing() {
        return this.passIfMissing;
    }

    public SingleColumnValueCondition setPassIfMissing(boolean passIfMissing) {
        this.passIfMissing = passIfMissing;
        return this;
    }

    public boolean isLatestVersionsOnly() {
        return this.latestVersionsOnly;
    }

    public SingleColumnValueCondition setLatestVersionsOnly(boolean latestVersionsOnly) {
        this.latestVersionsOnly = latestVersionsOnly;
        return this;
    }

    @Override
    public ColumnConditionType getConditionType() {
        return ColumnConditionType.SINGLE_COLUMN_VALUE_CONDITION;
    }

    public SingleColumnValueFilter toFilter() {
        SingleColumnValueFilter.CompareOperator filterOperator;
        switch (this.operator) {
            case EQUAL: {
                filterOperator = SingleColumnValueFilter.CompareOperator.EQUAL;
                break;
            }
            case NOT_EQUAL: {
                filterOperator = SingleColumnValueFilter.CompareOperator.NOT_EQUAL;
                break;
            }
            case GREATER_THAN: {
                filterOperator = SingleColumnValueFilter.CompareOperator.GREATER_THAN;
                break;
            }
            case GREATER_EQUAL: {
                filterOperator = SingleColumnValueFilter.CompareOperator.GREATER_EQUAL;
                break;
            }
            case LESS_THAN: {
                filterOperator = SingleColumnValueFilter.CompareOperator.LESS_THAN;
                break;
            }
            case LESS_EQUAL: {
                filterOperator = SingleColumnValueFilter.CompareOperator.LESS_EQUAL;
                break;
            }
            default: {
                throw new ClientException("Unknown operator: " + this.operator.name());
            }
        }
        SingleColumnValueFilter singleColumnValueFilter = new SingleColumnValueFilter(this.columnName, filterOperator, this.columnValue);
        singleColumnValueFilter.setLatestVersionsOnly(this.latestVersionsOnly);
        singleColumnValueFilter.setPassIfMissing(this.passIfMissing);
        return singleColumnValueFilter;
    }

    @Override
    public ByteString serialize() {
        return OTSProtocolBuilder.buildSingleColumnValueFilter(this.toFilter());
    }

    public static enum CompareOperator {
        EQUAL,
        NOT_EQUAL,
        GREATER_THAN,
        GREATER_EQUAL,
        LESS_THAN,
        LESS_EQUAL;

    }
}

