/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.crypto;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.crypto.ContentCryptoMaterial;
import com.aliyun.oss.crypto.ContentCryptoMode;
import com.aliyun.oss.crypto.CryptoCipher;
import com.aliyun.oss.crypto.CryptoConfiguration;
import com.aliyun.oss.crypto.CryptoModuleBase;
import com.aliyun.oss.crypto.CryptoScheme;
import com.aliyun.oss.crypto.EncryptionMaterials;
import com.aliyun.oss.crypto.OSSDirect;
import javax.crypto.SecretKey;

class CryptoModuleAesCtr
extends CryptoModuleBase {
    CryptoModuleAesCtr(OSSDirect OSS2, EncryptionMaterials encryptionMaterials, CryptoConfiguration cryptoConfig) {
        super(OSS2, encryptionMaterials, cryptoConfig);
    }

    @Override
    final byte[] generateIV() {
        byte[] iv = new byte[this.contentCryptoScheme.getContentChiperIVLength()];
        this.cryptoConfig.getSecureRandom().nextBytes(iv);
        if (this.cryptoConfig.getContentCryptoMode().equals((Object)ContentCryptoMode.AES_CTR_MODE)) {
            for (int i = 8; i < 12; ++i) {
                iv[i] = 0;
            }
        }
        return iv;
    }

    @Override
    final CryptoCipher createCryptoCipherFromContentMaterial(ContentCryptoMaterial cekMaterial, int cipherMode, long[] cryptoRange, long skipBlock) {
        boolean isRangeGet;
        if (cipherMode != 1 && cipherMode != 2) {
            throw new ClientException("Invalid cipher mode.");
        }
        byte[] iv = cekMaterial.getIV();
        SecretKey cek = cekMaterial.getCEK();
        String cekAlgo = cekMaterial.getContentCryptoAlgorithm();
        CryptoScheme tmpContentCryptoScheme = CryptoScheme.fromCEKAlgo(cekAlgo);
        boolean bl = isRangeGet = cryptoRange != null;
        if (isRangeGet) {
            iv = tmpContentCryptoScheme.adjustIV(iv, cryptoRange[0]);
        } else if (skipBlock > 0L) {
            iv = CryptoScheme.incrementBlocks(iv, skipBlock);
        }
        return tmpContentCryptoScheme.createCryptoCipher(cek, iv, cipherMode, this.cryptoConfig.getContentCryptoProvider());
    }
}

