/*
 * Decompiled with CFR 0.152.
 */
package com.anji.captcha.util;

import com.anji.captcha.util.CacheUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger logger = LoggerFactory.getLogger(CacheUtil.class);
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DAYTIME_START = "00:00:00";
    public static final String DAYTIME_END = "23:59:59";
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DC_DATE_FORMAT = "yyyy/MM/dd";
    public static final String DC_TIME_FORMAT = "yyyy/MM/dd HH:mm:ss";
    private static final String[] FORMATS = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH:mm:ss", "HH:mm", "HH:mm:ss", "yyyy-MM", "yyyy-MM-dd HH:mm:ss.S", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss"};

    public static List<String> getMonthBetweenDate(String startTime, String endTime, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        ArrayList<String> list = new ArrayList<String>();
        try {
            Date startDate = sdf.parse(startTime);
            Date endDate = sdf.parse(endTime);
            Calendar calendar = Calendar.getInstance();
            while (startDate.getTime() <= endDate.getTime()) {
                list.add(sdf.format(startDate));
                calendar.setTime(startDate);
                calendar.add(2, 1);
                startDate = calendar.getTime();
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static int differentDays(Date startDate, Date endDate) {
        Calendar sCalendar = Calendar.getInstance();
        sCalendar.setTime(startDate);
        sCalendar.set(11, 0);
        sCalendar.set(12, 0);
        sCalendar.set(13, 0);
        sCalendar.set(14, 0);
        Calendar eCalendar = Calendar.getInstance();
        eCalendar.setTime(endDate);
        eCalendar.set(11, 0);
        eCalendar.set(12, 0);
        eCalendar.set(13, 0);
        eCalendar.set(14, 0);
        System.out.println(eCalendar.getTimeInMillis());
        System.out.println(sCalendar.getTimeInMillis());
        int days = (int)((eCalendar.getTimeInMillis() - sCalendar.getTimeInMillis()) / 86400000L);
        return days;
    }

    public static Date afterDays(Date startDate, Integer days) {
        Calendar sCalendar = Calendar.getInstance();
        sCalendar.setTime(startDate);
        sCalendar.add(5, days);
        return sCalendar.getTime();
    }

    public static String convert(Date date, String dateFormat) {
        if (date == null) {
            return null;
        }
        if (null == dateFormat) {
            dateFormat = DATE_TIME_FORMAT;
        }
        return new SimpleDateFormat(dateFormat).format(date);
    }

    public static Date convert(String str) {
        if (str != null && str.length() > 0) {
            if (str.length() > 10 && str.charAt(10) == 'T') {
                str = str.replace('T', ' ');
            }
            for (String format : FORMATS) {
                if (str.length() != format.length()) continue;
                try {
                    Date date = new SimpleDateFormat(format).parse(str);
                    return date;
                }
                catch (ParseException e) {
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn(e.getMessage());
                }
            }
        }
        return null;
    }

    public static Date getStartDatetime(Date date) {
        String thisDate = DateUtils.convert(date, DATE_FORMAT);
        return DateUtils.convert(thisDate + " " + DAYTIME_START);
    }

    public static Date getEndDatetime(Date date) {
        String thisDate = DateUtils.convert(date, DATE_FORMAT);
        return DateUtils.convert(thisDate + " " + DAYTIME_END);
    }
}

