/*
 * Decompiled with CFR 0.152.
 */
package com.apptasticsoftware.rssreader;

import com.apptasticsoftware.rssreader.Item;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.util.Comparator;
import java.util.Locale;

public final class DateTime {
    private static ZoneId defaultZone = ZoneId.of("UTC");
    public static final DateTimeFormatter BASIC_ISO_DATE = DateTimeFormatter.BASIC_ISO_DATE.withLocale(Locale.ENGLISH);
    public static final DateTimeFormatter ISO_LOCAL_DATE = DateTimeFormatter.ISO_LOCAL_DATE.withLocale(Locale.ENGLISH);
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withLocale(Locale.ENGLISH);
    public static final DateTimeFormatter ISO_LOCAL_DATE_TIME = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withLocale(Locale.ENGLISH);
    public static final DateTimeFormatter ISO_LOCAL_DATE_TIME_SPECIAL = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter().withLocale(Locale.ENGLISH);
    public static final DateTimeFormatter RFC_1123_DATE_TIME = DateTimeFormatter.RFC_1123_DATE_TIME.withLocale(Locale.ENGLISH);
    public static final DateTimeFormatter RFC_1123_DATE_TIME_TIMEZONE = DateTimeFormatter.ofPattern("E, d LLL yyyy HH:mm:ss zzz", Locale.ENGLISH);
    public static final DateTimeFormatter RFC_1123_DATE_TIME_TIMEZONE2 = new DateTimeFormatterBuilder().appendPattern("E, d LLL yyyy HH:mm:ss").appendOffset("+H:mm", "+00").toFormatter().withLocale(Locale.ENGLISH);
    public static final DateTimeFormatter RFC_1123_DATE_TIME_NO_TIMEZONE = DateTimeFormatter.ofPattern("E, d LLL yyyy HH:mm:ss", Locale.ENGLISH).withZone(ZoneId.of("UTC"));
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL = DateTimeFormatter.ofPattern("E, d LLL yyyy HH:mm:ss z", Locale.ENGLISH);
    public static final DateTimeFormatter RFC_1123_DATE_TIME_GMT_OFFSET = DateTimeFormatter.ofPattern("E, d LLL yyyy HH:mm:ss O", Locale.ENGLISH);
    public static final DateTimeFormatter RFC_1123_DATE_TIME_GMT_AND_OFFSET = DateTimeFormatter.ofPattern("E, dd MMM yyyy HH:mm:ss 'GMT'Z", Locale.ENGLISH);
    public static final DateTimeFormatter RFC_822_DATE_TIME = DateTimeFormatter.ofPattern("E, d LLL yy HH:mm:ss X", Locale.ENGLISH);
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_EST;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_EDT;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_CST;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_CDT;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_MST;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_MDT;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_PST;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_PDT;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_FULL_EOW;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_GMT_OFFSET_FULL_EOW;
    public static final DateTimeFormatter RFC_822_DATE_TIME_FULL_EOW;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_EST_FULL_EOW;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_EDT_FULL_EOW;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_CST_FULL_EOW;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_CDT_FULL_EOW;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_MST_FULL_EOW;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_MDT_FULL_EOW;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_PST_FULL_EOW;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_PDT_FULL_EOW;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_NO_EOW;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_GMT_OFFSET_NO_EOW;
    public static final DateTimeFormatter RFC_822_DATE_TIME_NO_EOW;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_EST_NO_EOW;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_EDT_NO_EOW;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_CST_NO_EOW;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_CDT_NO_EOW;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_MST_NO_EOW;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_MDT_NO_EOW;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_PST_NO_EOW;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_PDT_NO_EOW;

    private DateTime() {
    }

    public static void setDefaultZone(ZoneId defaultZone) {
        DateTime.defaultZone = defaultZone;
    }

    public static LocalDateTime toLocalDateTime(String dateTime) {
        ZonedDateTime zonedDateTime = DateTime.toZonedDateTime(dateTime);
        if (zonedDateTime == null) {
            return null;
        }
        return zonedDateTime.toLocalDateTime();
    }

    public static ZonedDateTime toZonedDateTime(String dateTime) {
        if (dateTime == null) {
            return null;
        }
        DateTimeFormatter formatter = DateTime.getDateTimeFormatter(dateTime, false);
        if (formatter == null) {
            throw new IllegalArgumentException("Unknown date time format " + dateTime);
        }
        if (dateTime.length() == 19 || (dateTime.length() == 29 || dateTime.length() == 32 || dateTime.length() == 35) && dateTime.charAt(10) == 'T' || (dateTime.length() == 24 || dateTime.length() == 25) && dateTime.charAt(3) == ',') {
            LocalDateTime localDateTime = LocalDateTime.parse(dateTime, formatter);
            return ZonedDateTime.of(localDateTime, defaultZone);
        }
        try {
            if (DateTime.isDateOnly(formatter)) {
                LocalDate date = LocalDate.parse(dateTime, formatter);
                return ZonedDateTime.of(date, LocalTime.MIDNIGHT, defaultZone);
            }
            return ZonedDateTime.parse(dateTime, formatter);
        }
        catch (DateTimeParseException e) {
            int index = dateTime.indexOf(44);
            if (index != -1 && e.getMessage().contains("Conflict found: Field DayOfWeek")) {
                String newDateTime = dateTime.substring(index + 1).trim();
                try {
                    DateTimeFormatter newFormatter = DateTime.getDateTimeFormatter(newDateTime, true);
                    return ZonedDateTime.parse(newDateTime, newFormatter);
                }
                catch (DateTimeParseException e2) {
                    throw e;
                }
            }
            throw e;
        }
    }

    private static boolean isDateOnly(DateTimeFormatter formatter) {
        return formatter == ISO_LOCAL_DATE || formatter == BASIC_ISO_DATE;
    }

    private static DateTimeFormatter getDateTimeFormatter(String dateTime, boolean skipEndOfWeekPart) {
        if (skipEndOfWeekPart) {
            return DateTime.parseRfcDateTimeNoDayOfWeek(dateTime);
        }
        int index = dateTime.indexOf(44);
        if (index == -1) {
            return DateTime.parseIsoDateTime(dateTime);
        }
        if (index <= 3) {
            return DateTime.parseRfcDateTime(dateTime);
        }
        return DateTime.parseRfcDateTimeFullDayOfWeek(dateTime);
    }

    private static DateTimeFormatter parseIsoDateTime(String dateTime) {
        if (dateTime.length() >= 20 && dateTime.length() <= 35 && dateTime.charAt(4) == '-' && dateTime.charAt(10) == 'T') {
            return ISO_OFFSET_DATE_TIME;
        }
        if (dateTime.length() == 19 && dateTime.charAt(10) == 'T') {
            return ISO_LOCAL_DATE_TIME;
        }
        if (dateTime.length() == 19 && dateTime.charAt(10) == ' ') {
            return ISO_LOCAL_DATE_TIME_SPECIAL;
        }
        if (dateTime.length() == 10 && dateTime.charAt(4) == '-' && dateTime.charAt(7) == '-') {
            return ISO_LOCAL_DATE;
        }
        if (dateTime.length() == 8) {
            return BASIC_ISO_DATE;
        }
        return null;
    }

    private static DateTimeFormatter parseRfcDateTime(String dateTime) {
        if ((dateTime.length() == 28 || dateTime.length() == 29) && dateTime.charAt(3) == ',' && dateTime.endsWith(" UTC")) {
            return RFC_1123_DATE_TIME_SPECIAL;
        }
        if ((dateTime.length() == 28 || dateTime.length() == 29) && dateTime.charAt(3) == ',' && dateTime.endsWith(" EDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_EDT;
        }
        if ((dateTime.length() == 28 || dateTime.length() == 29) && dateTime.charAt(3) == ',' && dateTime.endsWith(" EST")) {
            return RFC_1123_DATE_TIME_SPECIAL_EST;
        }
        if ((dateTime.length() == 28 || dateTime.length() == 29) && dateTime.charAt(3) == ',' && dateTime.endsWith(" CDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_CDT;
        }
        if ((dateTime.length() == 28 || dateTime.length() == 29) && dateTime.charAt(3) == ',' && dateTime.endsWith(" CST")) {
            return RFC_1123_DATE_TIME_SPECIAL_CST;
        }
        if ((dateTime.length() == 28 || dateTime.length() == 29) && dateTime.charAt(3) == ',' && dateTime.endsWith(" MDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_MDT;
        }
        if ((dateTime.length() == 28 || dateTime.length() == 29) && dateTime.charAt(3) == ',' && dateTime.endsWith(" MST")) {
            return RFC_1123_DATE_TIME_SPECIAL_MST;
        }
        if ((dateTime.length() == 28 || dateTime.length() == 29) && dateTime.charAt(3) == ',' && dateTime.endsWith(" PDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_PDT;
        }
        if ((dateTime.length() == 28 || dateTime.length() == 29) && dateTime.charAt(3) == ',' && dateTime.endsWith(" PST")) {
            return RFC_1123_DATE_TIME_SPECIAL_PST;
        }
        if (dateTime.length() > 31 && dateTime.contains("GMT") && !dateTime.endsWith("GMT") && dateTime.lastIndexOf(58) < 29) {
            return RFC_1123_DATE_TIME_GMT_AND_OFFSET;
        }
        if (dateTime.length() >= 28 && dateTime.length() <= 35 && dateTime.charAt(3) == ',' && dateTime.contains("GMT")) {
            return RFC_1123_DATE_TIME_GMT_OFFSET;
        }
        if (!(dateTime.length() != 28 && dateTime.length() != 29 || dateTime.charAt(3) != ',' || dateTime.charAt(13) != ' ' && dateTime.charAt(14) != ' ')) {
            return RFC_822_DATE_TIME;
        }
        if (dateTime.length() >= 28 && dateTime.length() <= 31) {
            if (dateTime.contains(" +") || dateTime.contains(" -")) {
                return RFC_1123_DATE_TIME;
            }
            if (dateTime.contains("+") || dateTime.contains("-")) {
                return RFC_1123_DATE_TIME_TIMEZONE2;
            }
            return RFC_1123_DATE_TIME_TIMEZONE;
        }
        if ((dateTime.length() == 26 || dateTime.length() == 27) && dateTime.charAt(3) == ',' && dateTime.endsWith(" Z")) {
            return RFC_1123_DATE_TIME_SPECIAL;
        }
        if ((dateTime.length() == 24 || dateTime.length() == 25) && dateTime.charAt(3) == ',') {
            return RFC_1123_DATE_TIME_NO_TIMEZONE;
        }
        return null;
    }

    private static DateTimeFormatter parseRfcDateTimeFullDayOfWeek(String dateTime) {
        if (dateTime.endsWith(" UTC")) {
            return RFC_1123_DATE_TIME_SPECIAL_FULL_EOW;
        }
        if (dateTime.endsWith(" EDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_EDT_FULL_EOW;
        }
        if (dateTime.endsWith(" EST")) {
            return RFC_1123_DATE_TIME_SPECIAL_EST_FULL_EOW;
        }
        if (dateTime.endsWith(" CDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_CDT_FULL_EOW;
        }
        if (dateTime.endsWith(" CST")) {
            return RFC_1123_DATE_TIME_SPECIAL_CST_FULL_EOW;
        }
        if (dateTime.endsWith(" MDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_MDT_FULL_EOW;
        }
        if (dateTime.endsWith(" MST")) {
            return RFC_1123_DATE_TIME_SPECIAL_MST_FULL_EOW;
        }
        if (dateTime.endsWith(" PDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_PDT_FULL_EOW;
        }
        if (dateTime.endsWith(" PST")) {
            return RFC_1123_DATE_TIME_SPECIAL_PST_FULL_EOW;
        }
        if (dateTime.contains("GMT")) {
            return RFC_1123_DATE_TIME_GMT_OFFSET_FULL_EOW;
        }
        if (dateTime.endsWith(" Z")) {
            return RFC_1123_DATE_TIME_SPECIAL_FULL_EOW;
        }
        if (dateTime.contains("-") || dateTime.contains("+")) {
            return RFC_822_DATE_TIME_FULL_EOW;
        }
        return null;
    }

    private static DateTimeFormatter parseRfcDateTimeNoDayOfWeek(String dateTime) {
        if (dateTime.endsWith(" UTC")) {
            return RFC_1123_DATE_TIME_SPECIAL_NO_EOW;
        }
        if (dateTime.endsWith(" EDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_EDT_NO_EOW;
        }
        if (dateTime.endsWith(" EST")) {
            return RFC_1123_DATE_TIME_SPECIAL_EST_NO_EOW;
        }
        if (dateTime.endsWith(" CDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_CDT_NO_EOW;
        }
        if (dateTime.endsWith(" CST")) {
            return RFC_1123_DATE_TIME_SPECIAL_CST_NO_EOW;
        }
        if (dateTime.endsWith(" MDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_MDT_NO_EOW;
        }
        if (dateTime.endsWith(" MST")) {
            return RFC_1123_DATE_TIME_SPECIAL_MST_NO_EOW;
        }
        if (dateTime.endsWith(" PDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_PDT_NO_EOW;
        }
        if (dateTime.endsWith(" PST")) {
            return RFC_1123_DATE_TIME_SPECIAL_PST_NO_EOW;
        }
        if (dateTime.contains("GMT")) {
            return RFC_1123_DATE_TIME_GMT_OFFSET_NO_EOW;
        }
        if (dateTime.endsWith(" Z")) {
            return RFC_1123_DATE_TIME_SPECIAL_NO_EOW;
        }
        if (dateTime.contains("-") || dateTime.contains("+")) {
            return RFC_822_DATE_TIME_NO_EOW;
        }
        return null;
    }

    public static Long toEpochMilli(String dateTime) {
        ZonedDateTime zonedDateTime = DateTime.toZonedDateTime(dateTime);
        if (zonedDateTime == null) {
            return null;
        }
        return zonedDateTime.toInstant().toEpochMilli();
    }

    public static Instant toInstant(String dateTime) {
        ZonedDateTime zonedDateTime = DateTime.toZonedDateTime(dateTime);
        if (zonedDateTime == null) {
            return null;
        }
        return zonedDateTime.toInstant();
    }

    @Deprecated(since="3.3.0", forRemoval=true)
    public static Comparator<Item> pubDateComparator() {
        return Comparator.comparing(i -> i.getPubDate().map(DateTime::toInstant).orElse(Instant.EPOCH));
    }

    static {
        RFC_1123_DATE_TIME_SPECIAL_EDT = DateTimeFormatter.ofPattern("E, d LLL yyyy HH:mm:ss 'EDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-4));
        RFC_1123_DATE_TIME_SPECIAL_EST = DateTimeFormatter.ofPattern("E, d LLL yyyy HH:mm:ss 'EST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-5));
        RFC_1123_DATE_TIME_SPECIAL_CDT = DateTimeFormatter.ofPattern("E, d LLL yyyy HH:mm:ss 'CDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-5));
        RFC_1123_DATE_TIME_SPECIAL_CST = DateTimeFormatter.ofPattern("E, d LLL yyyy HH:mm:ss 'CST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-6));
        RFC_1123_DATE_TIME_SPECIAL_MDT = DateTimeFormatter.ofPattern("E, d LLL yyyy HH:mm:ss 'MDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-6));
        RFC_1123_DATE_TIME_SPECIAL_MST = DateTimeFormatter.ofPattern("E, d LLL yyyy HH:mm:ss 'MST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-7));
        RFC_1123_DATE_TIME_SPECIAL_PDT = DateTimeFormatter.ofPattern("E, d LLL yyyy HH:mm:ss 'PDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-7));
        RFC_1123_DATE_TIME_SPECIAL_PST = DateTimeFormatter.ofPattern("E, d LLL yyyy HH:mm:ss 'PST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-8));
        RFC_1123_DATE_TIME_SPECIAL_FULL_EOW = DateTimeFormatter.ofPattern("EEEE, d LLL yyyy HH:mm:ss z", Locale.ENGLISH);
        RFC_1123_DATE_TIME_GMT_OFFSET_FULL_EOW = DateTimeFormatter.ofPattern("EEEE, d LLL yyyy HH:mm:ss O", Locale.ENGLISH);
        RFC_822_DATE_TIME_FULL_EOW = DateTimeFormatter.ofPattern("EEEE, d LLL yyyy HH:mm:ss X", Locale.ENGLISH);
        RFC_1123_DATE_TIME_SPECIAL_EDT_FULL_EOW = DateTimeFormatter.ofPattern("EEEE, d LLL yyyy HH:mm:ss 'EDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-4));
        RFC_1123_DATE_TIME_SPECIAL_EST_FULL_EOW = DateTimeFormatter.ofPattern("EEEE, d LLL yyyy HH:mm:ss 'EST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-5));
        RFC_1123_DATE_TIME_SPECIAL_CDT_FULL_EOW = DateTimeFormatter.ofPattern("EEEE, d LLL yyyy HH:mm:ss 'CDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-5));
        RFC_1123_DATE_TIME_SPECIAL_CST_FULL_EOW = DateTimeFormatter.ofPattern("EEEE, d LLL yyyy HH:mm:ss 'CST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-6));
        RFC_1123_DATE_TIME_SPECIAL_MDT_FULL_EOW = DateTimeFormatter.ofPattern("EEEE, d LLL yyyy HH:mm:ss 'MDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-6));
        RFC_1123_DATE_TIME_SPECIAL_MST_FULL_EOW = DateTimeFormatter.ofPattern("EEEE, d LLL yyyy HH:mm:ss 'MST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-7));
        RFC_1123_DATE_TIME_SPECIAL_PDT_FULL_EOW = DateTimeFormatter.ofPattern("EEEE, d LLL yyyy HH:mm:ss 'PDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-7));
        RFC_1123_DATE_TIME_SPECIAL_PST_FULL_EOW = DateTimeFormatter.ofPattern("EEEE, d LLL yyyy HH:mm:ss 'PST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-8));
        RFC_1123_DATE_TIME_SPECIAL_NO_EOW = DateTimeFormatter.ofPattern("d LLL yyyy HH:mm:ss z", Locale.ENGLISH);
        RFC_1123_DATE_TIME_GMT_OFFSET_NO_EOW = DateTimeFormatter.ofPattern("d LLL yyyy HH:mm:ss O", Locale.ENGLISH);
        RFC_822_DATE_TIME_NO_EOW = DateTimeFormatter.ofPattern("d LLL yyyy HH:mm:ss X", Locale.ENGLISH);
        RFC_1123_DATE_TIME_SPECIAL_EDT_NO_EOW = DateTimeFormatter.ofPattern("d LLL yyyy HH:mm:ss 'EDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-4));
        RFC_1123_DATE_TIME_SPECIAL_EST_NO_EOW = DateTimeFormatter.ofPattern("d LLL yyyy HH:mm:ss 'EST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-5));
        RFC_1123_DATE_TIME_SPECIAL_CDT_NO_EOW = DateTimeFormatter.ofPattern("d LLL yyyy HH:mm:ss 'CDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-5));
        RFC_1123_DATE_TIME_SPECIAL_CST_NO_EOW = DateTimeFormatter.ofPattern("d LLL yyyy HH:mm:ss 'CST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-6));
        RFC_1123_DATE_TIME_SPECIAL_MDT_NO_EOW = DateTimeFormatter.ofPattern("d LLL yyyy HH:mm:ss 'MDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-6));
        RFC_1123_DATE_TIME_SPECIAL_MST_NO_EOW = DateTimeFormatter.ofPattern("d LLL yyyy HH:mm:ss 'MST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-7));
        RFC_1123_DATE_TIME_SPECIAL_PDT_NO_EOW = DateTimeFormatter.ofPattern("d LLL yyyy HH:mm:ss 'PDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-7));
        RFC_1123_DATE_TIME_SPECIAL_PST_NO_EOW = DateTimeFormatter.ofPattern("d LLL yyyy HH:mm:ss 'PST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-8));
    }
}

