/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.internal.ArangoContext;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.util.ArangoSerializationFactory;
import com.arangodb.internal.util.EncodeUtils;
import com.arangodb.util.ArangoSerialization;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.RequestType;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public abstract class ArangoExecuteable<E extends ArangoExecutor> {
    private static final String SLASH = "/";
    protected final E executor;
    protected final ArangoSerializationFactory util;
    protected final ArangoContext context;

    protected ArangoExecuteable(E executor, ArangoSerializationFactory util, ArangoContext context) {
        this.executor = executor;
        this.util = util;
        this.context = context;
    }

    protected E executor() {
        return this.executor;
    }

    public ArangoSerialization util() {
        return this.util.get(ArangoSerializationFactory.Serializer.INTERNAL);
    }

    public ArangoSerialization util(ArangoSerializationFactory.Serializer serializer) {
        return this.util.get(serializer);
    }

    protected Request request(String database, RequestType requestType, String ... path) {
        Request request = new Request(database, requestType, ArangoExecuteable.createPath(path));
        for (Map.Entry<String, String> header : this.context.getHeaderParam().entrySet()) {
            request.putHeaderParam(header.getKey(), header.getValue());
        }
        return request;
    }

    protected static String createPath(String ... params) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                sb.append(SLASH);
            }
            try {
                String param = params[i].contains(SLASH) ? ArangoExecuteable.createPath(params[i].split(SLASH)) : EncodeUtils.encodeURL(params[i]);
                sb.append(param);
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new ArangoDBException(e);
            }
        }
        return sb.toString();
    }
}

