/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoSearch;
import com.arangodb.entity.ViewEntity;
import com.arangodb.entity.arangosearch.ArangoSearchPropertiesEntity;
import com.arangodb.internal.ArangoDBImpl;
import com.arangodb.internal.ArangoDatabaseImpl;
import com.arangodb.internal.ArangoErrors;
import com.arangodb.internal.ArangoExecutorSync;
import com.arangodb.internal.InternalArangoSearch;
import com.arangodb.model.arangosearch.ArangoSearchCreateOptions;
import com.arangodb.model.arangosearch.ArangoSearchPropertiesOptions;
import java.lang.reflect.Type;

public class ArangoSearchImpl
extends InternalArangoSearch<ArangoDBImpl, ArangoDatabaseImpl, ArangoExecutorSync>
implements ArangoSearch {
    protected ArangoSearchImpl(ArangoDatabaseImpl db, String name) {
        super(db, name);
    }

    @Override
    public boolean exists() throws ArangoDBException {
        try {
            this.getInfo();
            return true;
        }
        catch (ArangoDBException e) {
            if (ArangoErrors.ERROR_ARANGO_DATA_SOURCE_NOT_FOUND.equals(e.getErrorNum())) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public void drop() throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.dropRequest(), (Type)((Object)Void.class));
    }

    @Override
    public synchronized ViewEntity rename(String newName) throws ArangoDBException {
        ViewEntity result = (ViewEntity)((ArangoExecutorSync)this.executor).execute(this.renameRequest(newName), (Type)((Object)ViewEntity.class));
        this.name = result.getName();
        return result;
    }

    @Override
    public ViewEntity getInfo() throws ArangoDBException {
        return (ViewEntity)((ArangoExecutorSync)this.executor).execute(this.getInfoRequest(), (Type)((Object)ViewEntity.class));
    }

    @Override
    public ViewEntity create() throws ArangoDBException {
        return this.create(new ArangoSearchCreateOptions());
    }

    @Override
    public ViewEntity create(ArangoSearchCreateOptions options) throws ArangoDBException {
        return ((ArangoDatabaseImpl)this.db()).createArangoSearch(this.name(), options);
    }

    @Override
    public ArangoSearchPropertiesEntity getProperties() throws ArangoDBException {
        return (ArangoSearchPropertiesEntity)((ArangoExecutorSync)this.executor).execute(this.getPropertiesRequest(), (Type)((Object)ArangoSearchPropertiesEntity.class));
    }

    @Override
    public ArangoSearchPropertiesEntity updateProperties(ArangoSearchPropertiesOptions options) throws ArangoDBException {
        return (ArangoSearchPropertiesEntity)((ArangoExecutorSync)this.executor).execute(this.updatePropertiesRequest(options), (Type)((Object)ArangoSearchPropertiesEntity.class));
    }

    @Override
    public ArangoSearchPropertiesEntity replaceProperties(ArangoSearchPropertiesOptions options) throws ArangoDBException {
        return (ArangoSearchPropertiesEntity)((ArangoExecutorSync)this.executor).execute(this.replacePropertiesRequest(options), (Type)((Object)ArangoSearchPropertiesEntity.class));
    }
}

