/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.net;

import com.arangodb.ArangoDBException;
import com.arangodb.internal.net.AccessType;
import com.arangodb.internal.net.Host;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.net.HostResolver;
import com.arangodb.internal.net.HostSet;
import java.util.List;

public class FallbackHostHandler
implements HostHandler {
    private final HostResolver resolver;
    private Host current;
    private Host lastSuccess;
    private int iterations;
    private boolean firstOpened;

    public FallbackHostHandler(HostResolver resolver) {
        this.resolver = resolver;
        this.iterations = 0;
        this.current = this.lastSuccess = resolver.resolve(true, false).getHostsList().get(0);
        this.firstOpened = true;
    }

    @Override
    public Host get(HostHandle hostHandle, AccessType accessType) {
        if (this.current != this.lastSuccess || this.iterations < 3) {
            return this.current;
        }
        this.reset();
        throw new ArangoDBException("Cannot contact any host!");
    }

    @Override
    public void success() {
        this.lastSuccess = this.current;
    }

    @Override
    public void fail() {
        List<Host> hosts = this.resolver.resolve(false, false).getHostsList();
        int index = hosts.indexOf(this.current) + 1;
        boolean inBound = index < hosts.size();
        this.current = hosts.get(inBound ? index : 0);
        if (!inBound) {
            ++this.iterations;
        }
    }

    @Override
    public void reset() {
        this.iterations = 0;
    }

    @Override
    public void confirm() {
        if (this.firstOpened) {
            this.resolver.resolve(false, false);
            this.firstOpened = false;
        }
    }

    @Override
    public void close() {
        HostSet hosts = this.resolver.resolve(false, false);
        hosts.close();
    }

    @Override
    public void closeCurrentOnError() {
        this.current.closeOnError();
    }
}

