/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.net;

import com.arangodb.ArangoDBException;
import com.arangodb.internal.net.AccessType;
import com.arangodb.internal.net.Host;
import com.arangodb.internal.net.HostDescription;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.net.HostResolver;
import com.arangodb.internal.net.HostSet;

public class RoundRobinHostHandler
implements HostHandler {
    private final HostResolver resolver;
    private int current;
    private int fails;
    private Host currentHost;
    private HostSet hosts;

    public RoundRobinHostHandler(HostResolver resolver) {
        this.resolver = resolver;
        this.hosts = resolver.resolve(true, false);
        this.current = 0;
        this.fails = 0;
    }

    @Override
    public Host get(HostHandle hostHandle, AccessType accessType) {
        this.hosts = this.resolver.resolve(false, false);
        int size = this.hosts.getHostsList().size();
        if (this.fails > size) {
            this.reset();
            throw new ArangoDBException("Cannot contact any host!");
        }
        int index = this.current++ % size;
        Host host = this.hosts.getHostsList().get(index);
        if (hostHandle != null) {
            HostDescription hostDescription = hostHandle.getHost();
            if (hostDescription != null) {
                for (int i = index; i < index + size && !hostDescription.equals((host = this.hosts.getHostsList().get(i % size)).getDescription()); ++i) {
                }
            } else {
                hostHandle.setHost(host.getDescription());
            }
        }
        this.currentHost = host;
        return host;
    }

    @Override
    public void success() {
        this.fails = 0;
    }

    @Override
    public void fail() {
        ++this.fails;
    }

    @Override
    public void reset() {
        this.fails = 0;
    }

    @Override
    public void confirm() {
    }

    @Override
    public void close() {
        this.hosts.close();
    }

    @Override
    public void closeCurrentOnError() {
        this.currentHost.closeOnError();
    }
}

