/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb;

import com.arangodb.internal.util.EncodeUtils;
import com.arangodb.util.UnicodeUtils;
import java.util.Objects;
import java.util.function.Supplier;

public final class DbName
implements Supplier<String> {
    public static final DbName SYSTEM = DbName.of("_system");
    private final String value;

    public static DbName of(String value) {
        UnicodeUtils.checkNormalized(value);
        return new DbName(value);
    }

    public static DbName normalize(String value) {
        return new DbName(UnicodeUtils.normalize(value));
    }

    private DbName(String value) {
        this.value = value;
    }

    @Override
    public String get() {
        return this.value;
    }

    public String getEncoded() {
        return EncodeUtils.encodeURIComponent(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DbName dbName = (DbName)o;
        return Objects.equals(this.value, dbName.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.get();
    }
}

