/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.async.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoMetrics;
import com.arangodb.DbName;
import com.arangodb.async.ArangoDBAsync;
import com.arangodb.async.ArangoDatabaseAsync;
import com.arangodb.async.internal.ArangoDatabaseAsyncImpl;
import com.arangodb.async.internal.ArangoExecutorAsync;
import com.arangodb.async.internal.velocystream.VstCommunicationAsync;
import com.arangodb.entity.ArangoDBVersion;
import com.arangodb.entity.LogEntity;
import com.arangodb.entity.LogEntriesEntity;
import com.arangodb.entity.LogLevelEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.QueryOptimizerRule;
import com.arangodb.entity.ServerRole;
import com.arangodb.entity.UserEntity;
import com.arangodb.internal.ArangoContext;
import com.arangodb.internal.ArangoExecutorSync;
import com.arangodb.internal.ArangoMetricsImpl;
import com.arangodb.internal.DocumentCache;
import com.arangodb.internal.InternalArangoDB;
import com.arangodb.internal.QueueTimeMetricsImpl;
import com.arangodb.internal.net.CommunicationProtocol;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.net.HostResolver;
import com.arangodb.internal.util.ArangoSerializationFactory;
import com.arangodb.internal.velocystream.VstCommunication;
import com.arangodb.internal.velocystream.VstCommunicationSync;
import com.arangodb.internal.velocystream.VstProtocol;
import com.arangodb.internal.velocystream.internal.VstConnectionSync;
import com.arangodb.model.DBCreateOptions;
import com.arangodb.model.LogOptions;
import com.arangodb.model.UserCreateOptions;
import com.arangodb.model.UserUpdateOptions;
import com.arangodb.velocypack.Type;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.Response;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArangoDBAsyncImpl
extends InternalArangoDB<ArangoExecutorAsync>
implements ArangoDBAsync {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArangoDBAsyncImpl.class);
    private final CommunicationProtocol cp;
    private final HostHandler asyncHostHandler;
    private final HostHandler syncHostHandler;

    public ArangoDBAsyncImpl(VstCommunicationAsync.Builder asyncCommBuilder, ArangoSerializationFactory util, VstCommunicationSync.Builder syncCommBuilder, HostResolver asyncHostResolver, HostResolver syncHostResolver, HostHandler asyncHostHandler, HostHandler syncHostHandler, ArangoContext context, int responseQueueTimeSamples, int timeoutMs) {
        super(new ArangoExecutorAsync(asyncCommBuilder.build(util.get(ArangoSerializationFactory.Serializer.INTERNAL)), util, new DocumentCache(), new QueueTimeMetricsImpl(responseQueueTimeSamples), timeoutMs), util, context);
        VstCommunication<Response, VstConnectionSync> cacheCom = syncCommBuilder.build(util.get(ArangoSerializationFactory.Serializer.INTERNAL));
        this.cp = new VstProtocol(cacheCom);
        this.asyncHostHandler = asyncHostHandler;
        this.syncHostHandler = syncHostHandler;
        ArangoExecutorSync arangoExecutorSync = new ArangoExecutorSync(this.cp, util, new DocumentCache(), new QueueTimeMetricsImpl(responseQueueTimeSamples), timeoutMs);
        asyncHostResolver.init(arangoExecutorSync, util.get(ArangoSerializationFactory.Serializer.INTERNAL));
        syncHostResolver.init(arangoExecutorSync, util.get(ArangoSerializationFactory.Serializer.INTERNAL));
    }

    @Override
    protected ArangoExecutorAsync executor() {
        return (ArangoExecutorAsync)this.executor;
    }

    @Override
    public void shutdown() throws ArangoDBException {
        try {
            ((ArangoExecutorAsync)this.executor).disconnect();
        }
        finally {
            try {
                this.cp.close();
            }
            catch (IOException e) {
                LOGGER.error("Got exception during shutdown:", (Throwable)e);
            }
        }
    }

    @Override
    public void updateJwt(String jwt) {
        this.asyncHostHandler.setJwt(jwt);
        this.syncHostHandler.setJwt(jwt);
        this.cp.setJwt(jwt);
        ((ArangoExecutorAsync)this.executor).setJwt(jwt);
    }

    @Override
    public ArangoDatabaseAsync db() {
        return this.db(DbName.SYSTEM);
    }

    @Override
    public ArangoDatabaseAsync db(DbName name) {
        return new ArangoDatabaseAsyncImpl(this, name);
    }

    @Override
    public ArangoMetrics metrics() {
        return new ArangoMetricsImpl(((ArangoExecutorAsync)this.executor).getQueueTimeMetrics());
    }

    @Override
    public CompletableFuture<Boolean> createDatabase(DbName name) {
        return this.createDatabase(new DBCreateOptions().name(name));
    }

    @Override
    public CompletableFuture<Boolean> createDatabase(DBCreateOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.createDatabaseRequest(options), this.createDatabaseResponseDeserializer());
    }

    @Override
    public CompletableFuture<Collection<String>> getDatabases() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getDatabasesRequest(this.db().dbName()), this.getDatabaseResponseDeserializer());
    }

    @Override
    public CompletableFuture<Collection<String>> getAccessibleDatabases() {
        return this.db().getAccessibleDatabases();
    }

    @Override
    public CompletableFuture<Collection<String>> getAccessibleDatabasesFor(String user) {
        return ((ArangoExecutorAsync)this.executor).execute(this.getAccessibleDatabasesForRequest(this.db().dbName(), user), this.getAccessibleDatabasesForResponseDeserializer());
    }

    @Override
    public CompletableFuture<ArangoDBVersion> getVersion() {
        return this.db().getVersion();
    }

    @Override
    public CompletableFuture<ServerRole> getRole() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getRoleRequest(), this.getRoleResponseDeserializer());
    }

    @Override
    public CompletableFuture<UserEntity> createUser(String user, String passwd) {
        return ((ArangoExecutorAsync)this.executor).execute(this.createUserRequest(this.db().dbName(), user, passwd, new UserCreateOptions()), (java.lang.reflect.Type)((Object)UserEntity.class));
    }

    @Override
    public CompletableFuture<UserEntity> createUser(String user, String passwd, UserCreateOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.createUserRequest(this.db().dbName(), user, passwd, options), (java.lang.reflect.Type)((Object)UserEntity.class));
    }

    @Override
    public CompletableFuture<Void> deleteUser(String user) {
        return ((ArangoExecutorAsync)this.executor).execute(this.deleteUserRequest(this.db().dbName(), user), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<UserEntity> getUser(String user) {
        return ((ArangoExecutorAsync)this.executor).execute(this.getUserRequest(this.db().dbName(), user), (java.lang.reflect.Type)((Object)UserEntity.class));
    }

    @Override
    public CompletableFuture<Collection<UserEntity>> getUsers() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getUsersRequest(this.db().dbName()), this.getUsersResponseDeserializer());
    }

    @Override
    public CompletableFuture<UserEntity> updateUser(String user, UserUpdateOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.updateUserRequest(this.db().dbName(), user, options), (java.lang.reflect.Type)((Object)UserEntity.class));
    }

    @Override
    public CompletableFuture<UserEntity> replaceUser(String user, UserUpdateOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.replaceUserRequest(this.db().dbName(), user, options), (java.lang.reflect.Type)((Object)UserEntity.class));
    }

    @Override
    public CompletableFuture<Void> grantDefaultDatabaseAccess(String user, Permissions permissions) {
        return ((ArangoExecutorAsync)this.executor).execute(this.updateUserDefaultDatabaseAccessRequest(user, permissions), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> grantDefaultCollectionAccess(String user, Permissions permissions) {
        return ((ArangoExecutorAsync)this.executor).execute(this.updateUserDefaultCollectionAccessRequest(user, permissions), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Response> execute(Request request) {
        return ((ArangoExecutorAsync)this.executor).execute(request, response -> response);
    }

    @Override
    public CompletableFuture<LogEntity> getLogs(LogOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.getLogsRequest(options), (java.lang.reflect.Type)((Object)LogEntity.class));
    }

    @Override
    public CompletableFuture<LogEntriesEntity> getLogEntries(LogOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.getLogEntriesRequest(options), (java.lang.reflect.Type)((Object)LogEntriesEntity.class));
    }

    @Override
    public CompletableFuture<LogLevelEntity> getLogLevel() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getLogLevelRequest(), (java.lang.reflect.Type)((Object)LogLevelEntity.class));
    }

    @Override
    public CompletableFuture<LogLevelEntity> setLogLevel(LogLevelEntity entity) {
        return ((ArangoExecutorAsync)this.executor).execute(this.setLogLevelRequest(entity), (java.lang.reflect.Type)((Object)LogLevelEntity.class));
    }

    @Override
    public CompletableFuture<Collection<QueryOptimizerRule>> getQueryOptimizerRules() throws ArangoDBException {
        return ((ArangoExecutorAsync)this.executor).execute(this.getQueryOptimizerRulesRequest(), new Type<Collection<QueryOptimizerRule>>(){}.getType());
    }
}

