/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.async.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.async.internal.velocystream.VstCommunicationAsync;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.DocumentCache;
import com.arangodb.internal.QueueTimeMetricsImpl;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.internal.util.ArangoSerializationFactory;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.Response;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ArangoExecutorAsync
extends ArangoExecutor {
    private final VstCommunicationAsync communication;
    private final ExecutorService outgoingExecutor = Executors.newSingleThreadExecutor();

    public ArangoExecutorAsync(VstCommunicationAsync communication, ArangoSerializationFactory util, DocumentCache documentCache, QueueTimeMetricsImpl qtMetrics, int timeoutMs) {
        super(util, documentCache, qtMetrics, timeoutMs);
        this.communication = communication;
    }

    public <T> CompletableFuture<T> execute(Request request, Type type) {
        return this.execute(request, (Response response) -> this.createResult(type, response));
    }

    public <T> CompletableFuture<T> execute(Request request, Type type, HostHandle hostHandle) {
        return this.execute(request, (Response response) -> this.createResult(type, response), hostHandle);
    }

    public <T> CompletableFuture<T> execute(Request request, ArangoExecutor.ResponseDeserializer<T> responseDeserializer) {
        return this.execute(request, responseDeserializer, null);
    }

    private <T> CompletableFuture<T> execute(Request request, ArangoExecutor.ResponseDeserializer<T> responseDeserializer, HostHandle hostHandle) {
        return ((CompletableFuture)CompletableFuture.completedFuture(null).thenComposeAsync(it -> (CompletableFuture)this.communication.execute(this.interceptRequest(request), hostHandle), (Executor)this.outgoingExecutor)).thenApplyAsync(response -> {
            this.interceptResponse((Response)response);
            return responseDeserializer.deserialize((Response)response);
        });
    }

    public void disconnect() {
        try {
            this.communication.close();
        }
        catch (IOException e) {
            throw new ArangoDBException(e);
        }
        finally {
            this.outgoingExecutor.shutdown();
        }
    }

    public void setJwt(String jwt) {
        this.communication.setJwt(jwt);
    }
}

