/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.entity.DocumentField;
import com.arangodb.entity.From;
import com.arangodb.entity.Id;
import com.arangodb.entity.Key;
import com.arangodb.entity.Rev;
import com.arangodb.entity.To;
import com.arangodb.internal.DocumentFields;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DocumentCache {
    private final Map<Class<?>, Map<String, Field>> cache = new HashMap();

    public void setValues(Object doc, Map<String, String> values) throws ArangoDBException {
        try {
            Map<String, Field> fields = this.getFields(doc.getClass());
            for (Map.Entry<String, String> value : values.entrySet()) {
                Field field = fields.get(value.getKey());
                if (field == null) continue;
                field.set(doc, value.getValue());
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new ArangoDBException(e);
        }
    }

    private Map<String, Field> getFields(Class<?> clazz) {
        Map<String, Field> fields = new HashMap<String, Field>();
        if (!this.isTypeRestricted(clazz) && (fields = this.cache.get(clazz)) == null) {
            fields = this.createFields(clazz);
            this.cache.put(clazz, fields);
        }
        return fields;
    }

    private boolean isTypeRestricted(Class<?> type) {
        return Map.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type);
    }

    private Map<String, Field> createFields(Class<?> clazz) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        ArrayList<String> values = new ArrayList<String>(DocumentFields.values());
        for (Class<?> tmp = clazz; tmp != null && tmp != Object.class && values.size() > 0; tmp = tmp.getSuperclass()) {
            Field[] declaredFields = tmp.getDeclaredFields();
            for (int i = 0; i < declaredFields.length && values.size() > 0; ++i) {
                this.findAnnotation(values, fields, declaredFields[i]);
            }
        }
        return fields;
    }

    private void findAnnotation(Collection<String> values, Map<String, Field> fields, Field field) {
        for (Annotation annotation : field.getAnnotations()) {
            if (annotation == null || field.isSynthetic() || Modifier.isStatic(field.getModifiers()) || !String.class.isAssignableFrom(field.getType())) continue;
            String value = null;
            if (annotation instanceof DocumentField) {
                value = ((DocumentField)annotation).value().getSerializeName();
            } else if (annotation instanceof Id) {
                value = "_id";
            } else if (annotation instanceof Key) {
                value = "_key";
            } else if (annotation instanceof Rev) {
                value = "_rev";
            } else if (annotation instanceof From) {
                value = "_from";
            } else if (annotation instanceof To) {
                value = "_to";
            }
            if (!values.contains(value)) continue;
            field.setAccessible(true);
            fields.put(value, field);
            values.remove(value);
        }
    }
}

