/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.model;

import com.arangodb.entity.CollectionType;
import com.arangodb.entity.KeyOptions;
import com.arangodb.entity.KeyType;
import com.arangodb.entity.MinReplicationFactor;
import com.arangodb.entity.ReplicationFactor;
import com.arangodb.model.CollectionSchema;
import com.arangodb.model.ComputedValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CollectionCreateOptions {
    private String name;
    private Long journalSize;
    private final ReplicationFactor replicationFactor;
    private final MinReplicationFactor minReplicationFactor;
    private Integer writeConcern;
    private KeyOptions keyOptions;
    private Boolean waitForSync;
    private List<ComputedValue> computedValues = new ArrayList<ComputedValue>();
    @Deprecated
    private Boolean doCompact;
    @Deprecated
    private Boolean isVolatile;
    private String[] shardKeys;
    private Integer numberOfShards;
    private Boolean isSystem;
    private CollectionType type;
    @Deprecated
    private Integer indexBuckets;
    private String distributeShardsLike;
    private String shardingStrategy;
    private String smartJoinAttribute;
    private CollectionSchema schema;

    public CollectionCreateOptions() {
        this.replicationFactor = new ReplicationFactor();
        this.minReplicationFactor = new MinReplicationFactor();
    }

    protected String getName() {
        return this.name;
    }

    protected CollectionCreateOptions name(String name) {
        this.name = name;
        return this;
    }

    @Deprecated
    public Long getJournalSize() {
        return this.journalSize;
    }

    @Deprecated
    public CollectionCreateOptions journalSize(Long journalSize) {
        this.journalSize = journalSize;
        return this;
    }

    public Integer getReplicationFactor() {
        return this.replicationFactor.getReplicationFactor();
    }

    @Deprecated
    public Integer getMinReplicationFactor() {
        return this.minReplicationFactor.getMinReplicationFactor();
    }

    public CollectionCreateOptions replicationFactor(Integer replicationFactor) {
        this.replicationFactor.setReplicationFactor(replicationFactor);
        return this;
    }

    @Deprecated
    public CollectionCreateOptions minReplicationFactor(Integer minReplicationFactor) {
        this.minReplicationFactor.setMinReplicationFactor(minReplicationFactor);
        return this;
    }

    public Integer getWriteConcern() {
        return this.writeConcern;
    }

    public CollectionCreateOptions writeConcern(Integer writeConcern) {
        this.writeConcern = writeConcern;
        return this;
    }

    public Boolean getSatellite() {
        return this.replicationFactor.getSatellite();
    }

    public CollectionCreateOptions satellite(Boolean satellite) {
        this.replicationFactor.setSatellite(satellite);
        return this;
    }

    public KeyOptions getKeyOptions() {
        return this.keyOptions;
    }

    public CollectionCreateOptions keyOptions(Boolean allowUserKeys, KeyType type, Integer increment, Integer offset) {
        this.keyOptions = new KeyOptions(allowUserKeys, type, increment, offset);
        return this;
    }

    public Boolean getWaitForSync() {
        return this.waitForSync;
    }

    public CollectionCreateOptions waitForSync(Boolean waitForSync) {
        this.waitForSync = waitForSync;
        return this;
    }

    @Deprecated
    public Boolean getDoCompact() {
        return this.doCompact;
    }

    @Deprecated
    public CollectionCreateOptions doCompact(Boolean doCompact) {
        this.doCompact = doCompact;
        return this;
    }

    @Deprecated
    public Boolean getIsVolatile() {
        return this.isVolatile;
    }

    @Deprecated
    public CollectionCreateOptions isVolatile(Boolean isVolatile) {
        this.isVolatile = isVolatile;
        return this;
    }

    public String[] getShardKeys() {
        return this.shardKeys;
    }

    public CollectionCreateOptions shardKeys(String ... shardKeys) {
        this.shardKeys = shardKeys;
        return this;
    }

    public CollectionCreateOptions smartJoinAttribute(String smartJoinAttribute) {
        this.smartJoinAttribute = smartJoinAttribute;
        return this;
    }

    public String getSmartJoinAttribute() {
        return this.smartJoinAttribute;
    }

    public CollectionCreateOptions shardingStrategy(String shardingStrategy) {
        this.shardingStrategy = shardingStrategy;
        return this;
    }

    public String getShardingStrategy() {
        return this.shardingStrategy;
    }

    public CollectionCreateOptions numberOfShards(Integer numberOfShards) {
        this.numberOfShards = numberOfShards;
        return this;
    }

    public Integer getNumberOfShards() {
        return this.numberOfShards;
    }

    public Boolean getIsSystem() {
        return this.isSystem;
    }

    public CollectionCreateOptions isSystem(Boolean isSystem) {
        this.isSystem = isSystem;
        return this;
    }

    public CollectionType getType() {
        return this.type;
    }

    public CollectionCreateOptions type(CollectionType type) {
        this.type = type;
        return this;
    }

    @Deprecated
    public Integer getIndexBuckets() {
        return this.indexBuckets;
    }

    @Deprecated
    public CollectionCreateOptions indexBuckets(Integer indexBuckets) {
        this.indexBuckets = indexBuckets;
        return this;
    }

    public String getDistributeShardsLike() {
        return this.distributeShardsLike;
    }

    public CollectionCreateOptions distributeShardsLike(String distributeShardsLike) {
        this.distributeShardsLike = distributeShardsLike;
        return this;
    }

    public CollectionSchema getSchema() {
        return this.schema;
    }

    public CollectionCreateOptions schema(CollectionSchema schema) {
        this.schema = schema;
        return this;
    }

    @Deprecated
    public CollectionCreateOptions setSchema(CollectionSchema schema) {
        this.schema = schema;
        return this;
    }

    public CollectionCreateOptions computedValues(ComputedValue ... computedValues) {
        Collections.addAll(this.computedValues, computedValues);
        return this;
    }
}

