/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.core.convert;

import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.ISODateTimeFormat;

public final class JodaTimeUtil {
    private JodaTimeUtil() {
    }

    public static String format(Instant source) {
        return ISODateTimeFormat.dateTime().print((ReadableInstant)source);
    }

    public static String format(DateTime source) {
        return ISODateTimeFormat.dateTime().print((ReadableInstant)source);
    }

    public static String format(LocalDate source) {
        return ISODateTimeFormat.yearMonthDay().print((ReadablePartial)source);
    }

    public static String format(LocalDateTime source) {
        return ISODateTimeFormat.dateTime().print((ReadablePartial)source);
    }

    public static Instant parseInstant(String source) {
        return Instant.parse((String)source);
    }

    public static DateTime parseDateTime(String source) {
        return DateTime.parse((String)source);
    }

    public static LocalDate parseLocalDate(String source) {
        return LocalDate.parse((String)source);
    }

    public static LocalDateTime parseLocalDateTime(String source) {
        return LocalDateTime.parse((String)source);
    }
}

