/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.core.convert;

import com.arangodb.springframework.core.convert.JavaTimeUtil;
import com.arangodb.velocypack.internal.util.DateUtil;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;

public class TimeStringConverters {
    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        ArrayList converters = new ArrayList();
        converters.add(DateToStringConverter.INSTANCE);
        converters.add(InstantToStringConverter.INSTANCE);
        converters.add(LocalDateToStringConverter.INSTANCE);
        converters.add(LocalDateTimeToStringConverter.INSTANCE);
        converters.add(OffsetDateTimeToStringConverter.INSTANCE);
        converters.add(ZonedDateTimeToStringConverter.INSTANCE);
        converters.add(StringToDateConverter.INSTANCE);
        converters.add(StringToInstantConverter.INSTANCE);
        converters.add(StringToLocalDateConverter.INSTANCE);
        converters.add(StringToLocalDateTimeConverter.INSTANCE);
        converters.add(StringToOffsetDateTimeConverter.INSTANCE);
        converters.add(StringToZonedDateTimeConverter.INSTANCE);
        return converters;
    }

    private static Date parseDate(String source) {
        try {
            return source == null ? null : DateUtil.parse((String)source);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @ReadingConverter
    public static enum StringToZonedDateTimeConverter implements Converter<String, ZonedDateTime>
    {
        INSTANCE;


        public ZonedDateTime convert(String source) {
            return source == null ? null : JavaTimeUtil.parseZonedDateTime(source);
        }
    }

    @ReadingConverter
    public static enum StringToOffsetDateTimeConverter implements Converter<String, OffsetDateTime>
    {
        INSTANCE;


        public OffsetDateTime convert(String source) {
            return source == null ? null : JavaTimeUtil.parseOffsetDateTime(source);
        }
    }

    @ReadingConverter
    public static enum StringToLocalDateTimeConverter implements Converter<String, LocalDateTime>
    {
        INSTANCE;


        public LocalDateTime convert(String source) {
            return source == null ? null : JavaTimeUtil.parseLocalDateTime(source);
        }
    }

    @ReadingConverter
    public static enum StringToLocalDateConverter implements Converter<String, LocalDate>
    {
        INSTANCE;


        public LocalDate convert(String source) {
            return source == null ? null : JavaTimeUtil.parseLocalDate(source);
        }
    }

    @ReadingConverter
    public static enum StringToInstantConverter implements Converter<String, Instant>
    {
        INSTANCE;


        public Instant convert(String source) {
            return source == null ? null : JavaTimeUtil.parseInstant(source);
        }
    }

    @WritingConverter
    public static enum ZonedDateTimeToStringConverter implements Converter<ZonedDateTime, String>
    {
        INSTANCE;


        public String convert(ZonedDateTime source) {
            return source == null ? null : JavaTimeUtil.format(source);
        }
    }

    @WritingConverter
    public static enum OffsetDateTimeToStringConverter implements Converter<OffsetDateTime, String>
    {
        INSTANCE;


        public String convert(OffsetDateTime source) {
            return source == null ? null : JavaTimeUtil.format(source);
        }
    }

    @WritingConverter
    public static enum LocalDateTimeToStringConverter implements Converter<LocalDateTime, String>
    {
        INSTANCE;


        public String convert(LocalDateTime source) {
            return source == null ? null : JavaTimeUtil.format(source);
        }
    }

    @WritingConverter
    public static enum LocalDateToStringConverter implements Converter<LocalDate, String>
    {
        INSTANCE;


        public String convert(LocalDate source) {
            return source == null ? null : JavaTimeUtil.format(source);
        }
    }

    @WritingConverter
    public static enum InstantToStringConverter implements Converter<Instant, String>
    {
        INSTANCE;


        public String convert(Instant source) {
            return source == null ? null : JavaTimeUtil.format(source);
        }
    }

    @ReadingConverter
    public static enum StringToDateConverter implements Converter<String, Date>
    {
        INSTANCE;


        public Date convert(String source) {
            return TimeStringConverters.parseDate(source);
        }
    }

    @WritingConverter
    public static enum DateToStringConverter implements Converter<Date, String>
    {
        INSTANCE;


        public String convert(Date source) {
            return source == null ? null : DateUtil.format((Date)source);
        }
    }
}

