/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.core.convert.resolver;

import com.arangodb.ArangoCursor;
import com.arangodb.model.AqlQueryOptions;
import com.arangodb.springframework.annotation.To;
import com.arangodb.springframework.core.ArangoOperations;
import com.arangodb.springframework.core.convert.resolver.AbstractResolver;
import com.arangodb.springframework.core.convert.resolver.RelationResolver;
import com.arangodb.util.MapBuilder;
import org.springframework.data.util.TypeInformation;

public class DocumentToResolver
extends AbstractResolver<To>
implements RelationResolver<To> {
    private final ArangoOperations template;

    public DocumentToResolver(ArangoOperations template) {
        super(template.getConverter().getConversionService());
        this.template = template;
    }

    @Override
    public Object resolveOne(String id, TypeInformation<?> type, To annotation) {
        return annotation.lazy() ? this.proxy(id, type, annotation, (i, t, a) -> this._resolveOne(i, t)) : this._resolveOne(id, type);
    }

    private Object _resolveOne(String id, TypeInformation<?> type) {
        return this._resolve(id, type.getType(), true).first();
    }

    @Override
    public Object resolveMultiple(String id, TypeInformation<?> type, To annotation) {
        return annotation.lazy() ? this.proxy(id, type, annotation, (i, t, a) -> this._resolveMultiple(i, t)) : this._resolveMultiple(id, type);
    }

    private Object _resolveMultiple(String id, TypeInformation<?> type) {
        return this._resolve(id, DocumentToResolver.getNonNullComponentType(type).getType(), false).asListRemaining();
    }

    private ArangoCursor<?> _resolve(String id, Class<?> type, boolean limit) {
        String query = String.format("FOR e IN @@edge FILTER e._to == @id RETURN e", limit ? "LIMIT 1" : "");
        return this.template.query(query, new MapBuilder().put("@edge", type).put("id", (Object)id).get(), new AqlQueryOptions(), type);
    }
}

