/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.core.template;

import com.arangodb.ArangoCollection;
import com.arangodb.ArangoCursor;
import com.arangodb.ArangoDB;
import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDatabase;
import com.arangodb.entity.ArangoDBVersion;
import com.arangodb.entity.DocumentCreateEntity;
import com.arangodb.entity.DocumentDeleteEntity;
import com.arangodb.entity.DocumentEntity;
import com.arangodb.entity.DocumentUpdateEntity;
import com.arangodb.entity.MultiDocumentEntity;
import com.arangodb.entity.UserEntity;
import com.arangodb.model.AqlQueryOptions;
import com.arangodb.model.CollectionCreateOptions;
import com.arangodb.model.DocumentCreateOptions;
import com.arangodb.model.DocumentDeleteOptions;
import com.arangodb.model.DocumentReadOptions;
import com.arangodb.model.DocumentReplaceOptions;
import com.arangodb.model.DocumentUpdateOptions;
import com.arangodb.model.FulltextIndexOptions;
import com.arangodb.model.GeoIndexOptions;
import com.arangodb.model.HashIndexOptions;
import com.arangodb.model.PersistentIndexOptions;
import com.arangodb.model.SkiplistIndexOptions;
import com.arangodb.model.TtlIndexOptions;
import com.arangodb.springframework.annotation.FulltextIndex;
import com.arangodb.springframework.annotation.GeoIndex;
import com.arangodb.springframework.annotation.HashIndex;
import com.arangodb.springframework.annotation.PersistentIndex;
import com.arangodb.springframework.annotation.SkiplistIndex;
import com.arangodb.springframework.annotation.TtlIndex;
import com.arangodb.springframework.core.ArangoOperations;
import com.arangodb.springframework.core.CollectionOperations;
import com.arangodb.springframework.core.UserOperations;
import com.arangodb.springframework.core.convert.ArangoConverter;
import com.arangodb.springframework.core.convert.resolver.ResolverFactory;
import com.arangodb.springframework.core.mapping.ArangoPersistentEntity;
import com.arangodb.springframework.core.mapping.ArangoPersistentProperty;
import com.arangodb.springframework.core.mapping.event.AfterDeleteEvent;
import com.arangodb.springframework.core.mapping.event.AfterLoadEvent;
import com.arangodb.springframework.core.mapping.event.AfterSaveEvent;
import com.arangodb.springframework.core.mapping.event.ArangoMappingEvent;
import com.arangodb.springframework.core.mapping.event.BeforeDeleteEvent;
import com.arangodb.springframework.core.mapping.event.BeforeSaveEvent;
import com.arangodb.springframework.core.template.ArangoCursorInitializer;
import com.arangodb.springframework.core.template.CollectionCacheKey;
import com.arangodb.springframework.core.template.CollectionCacheValue;
import com.arangodb.springframework.core.template.DefaultCollectionOperations;
import com.arangodb.springframework.core.template.DefaultUserOperation;
import com.arangodb.springframework.core.util.ArangoExceptionTranslator;
import com.arangodb.springframework.core.util.MetadataUtils;
import com.arangodb.util.MapBuilder;
import com.arangodb.velocypack.VPackSlice;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.domain.Persistable;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ArangoTemplate
implements ArangoOperations,
DefaultUserOperation.CollectionCallback,
ApplicationContextAware {
    private static final String REPSERT_QUERY_BODY = "UPSERT { _key: doc._key } INSERT doc._key == null ? UNSET(doc, \"_key\") : doc REPLACE doc IN @@col OPTIONS { ignoreRevs: false } RETURN NEW";
    private static final String REPSERT_QUERY = "LET doc = @doc UPSERT { _key: doc._key } INSERT doc._key == null ? UNSET(doc, \"_key\") : doc REPLACE doc IN @@col OPTIONS { ignoreRevs: false } RETURN NEW";
    private static final String REPSERT_MANY_QUERY = "FOR doc IN @docs UPSERT { _key: doc._key } INSERT doc._key == null ? UNSET(doc, \"_key\") : doc REPLACE doc IN @@col OPTIONS { ignoreRevs: false } RETURN NEW";
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private volatile ArangoDBVersion version;
    private final PersistenceExceptionTranslator exceptionTranslator;
    private final ArangoConverter converter;
    private final ResolverFactory resolverFactory;
    private final ArangoDB arango;
    private final String databaseName;
    private final Expression databaseExpression;
    private final Map<String, ArangoDatabase> databaseCache;
    private final Map<CollectionCacheKey, CollectionCacheValue> collectionCache;
    private final StandardEvaluationContext context;
    private ApplicationEventPublisher eventPublisher;

    public ArangoTemplate(ArangoDB arango, String database, ArangoConverter converter, ResolverFactory resolverFactory) {
        this(arango, database, converter, resolverFactory, new ArangoExceptionTranslator());
    }

    public ArangoTemplate(ArangoDB arango, String database, ArangoConverter converter, ResolverFactory resolverFactory, PersistenceExceptionTranslator exceptionTranslator) {
        this.arango = arango._setCursorInitializer((com.arangodb.util.ArangoCursorInitializer)new ArangoCursorInitializer(converter));
        this.databaseName = database;
        this.databaseExpression = PARSER.parseExpression(this.databaseName, ParserContext.TEMPLATE_EXPRESSION);
        this.converter = converter;
        this.resolverFactory = resolverFactory;
        this.exceptionTranslator = exceptionTranslator;
        this.context = new StandardEvaluationContext();
        this.collectionCache = new ConcurrentHashMap<CollectionCacheKey, CollectionCacheValue>(8, 0.9f, 1);
        this.databaseCache = new ConcurrentHashMap<String, ArangoDatabase>(8, 0.9f, 1);
        this.version = null;
    }

    private ArangoDatabase db() {
        String key = this.databaseExpression != null ? (String)this.databaseExpression.getValue((EvaluationContext)this.context, String.class) : this.databaseName;
        return this.databaseCache.computeIfAbsent(key, name -> {
            ArangoDatabase db = this.arango.db(name);
            if (!db.exists()) {
                db.create();
            }
            return db;
        });
    }

    private DataAccessException translateExceptionIfPossible(RuntimeException exception) {
        return this.exceptionTranslator.translateExceptionIfPossible(exception);
    }

    private ArangoCollection _collection(String name) {
        return this._collection(name, null, null);
    }

    private ArangoCollection _collection(Class<?> entityClass) {
        return this._collection(entityClass, null);
    }

    private ArangoCollection _collection(Class<?> entityClass, Object id) {
        ArangoPersistentEntity persistentEntity = (ArangoPersistentEntity)this.converter.getMappingContext().getRequiredPersistentEntity(entityClass);
        String name = this.determineCollectionFromId(id).orElse(persistentEntity.getCollection());
        return this._collection(name, persistentEntity, persistentEntity.getCollectionOptions());
    }

    private ArangoCollection _collection(String name, ArangoPersistentEntity<?> persistentEntity, CollectionCreateOptions options) {
        ArangoDatabase db = this.db();
        Class entityClass = persistentEntity != null ? persistentEntity.getType() : null;
        CollectionCacheValue value = this.collectionCache.computeIfAbsent(new CollectionCacheKey(db.name(), name), key -> {
            ArangoCollection collection = db.collection(name);
            if (!collection.exists()) {
                collection.create(options);
            }
            return new CollectionCacheValue(collection);
        });
        Collection<Class<?>> entities = value.getEntities();
        ArangoCollection collection = value.getCollection();
        if (persistentEntity != null && !entities.contains(entityClass)) {
            value.addEntityClass(entityClass);
            ArangoTemplate.ensureCollectionIndexes(this.collection(collection), persistentEntity);
        }
        return collection;
    }

    private static void ensureCollectionIndexes(CollectionOperations collection, ArangoPersistentEntity<?> persistentEntity) {
        persistentEntity.getHashIndexes().stream().forEach(index -> ArangoTemplate.ensureHashIndex(collection, index));
        persistentEntity.getHashIndexedProperties().stream().forEach(p -> ArangoTemplate.ensureHashIndex(collection, p));
        persistentEntity.getSkiplistIndexes().stream().forEach(index -> ArangoTemplate.ensureSkiplistIndex(collection, index));
        persistentEntity.getSkiplistIndexedProperties().stream().forEach(p -> ArangoTemplate.ensureSkiplistIndex(collection, p));
        persistentEntity.getPersistentIndexes().stream().forEach(index -> ArangoTemplate.ensurePersistentIndex(collection, index));
        persistentEntity.getPersistentIndexedProperties().stream().forEach(p -> ArangoTemplate.ensurePersistentIndex(collection, p));
        persistentEntity.getGeoIndexes().stream().forEach(index -> ArangoTemplate.ensureGeoIndex(collection, index));
        persistentEntity.getGeoIndexedProperties().stream().forEach(p -> ArangoTemplate.ensureGeoIndex(collection, p));
        persistentEntity.getFulltextIndexes().stream().forEach(index -> ArangoTemplate.ensureFulltextIndex(collection, index));
        persistentEntity.getFulltextIndexedProperties().stream().forEach(p -> ArangoTemplate.ensureFulltextIndex(collection, p));
        persistentEntity.getTtlIndex().ifPresent(index -> ArangoTemplate.ensureTtlIndex(collection, index));
        persistentEntity.getTtlIndexedProperty().ifPresent(p -> ArangoTemplate.ensureTtlIndex(collection, p));
    }

    private static void ensureHashIndex(CollectionOperations collection, HashIndex annotation) {
        collection.ensureHashIndex(Arrays.asList(annotation.fields()), new HashIndexOptions().unique(Boolean.valueOf(annotation.unique())).sparse(Boolean.valueOf(annotation.sparse())).deduplicate(Boolean.valueOf(annotation.deduplicate())));
    }

    private static void ensureHashIndex(CollectionOperations collection, ArangoPersistentProperty value) {
        HashIndexOptions options = new HashIndexOptions();
        value.getHashIndexed().ifPresent(i -> options.unique(Boolean.valueOf(i.unique())).sparse(Boolean.valueOf(i.sparse())).deduplicate(Boolean.valueOf(i.deduplicate())));
        collection.ensureHashIndex(Collections.singleton(value.getFieldName()), options);
    }

    private static void ensureSkiplistIndex(CollectionOperations collection, SkiplistIndex annotation) {
        collection.ensureSkiplistIndex(Arrays.asList(annotation.fields()), new SkiplistIndexOptions().unique(Boolean.valueOf(annotation.unique())).sparse(Boolean.valueOf(annotation.sparse())).deduplicate(Boolean.valueOf(annotation.deduplicate())));
    }

    private static void ensureSkiplistIndex(CollectionOperations collection, ArangoPersistentProperty value) {
        SkiplistIndexOptions options = new SkiplistIndexOptions();
        value.getSkiplistIndexed().ifPresent(i -> options.unique(Boolean.valueOf(i.unique())).sparse(Boolean.valueOf(i.sparse())).deduplicate(Boolean.valueOf(i.deduplicate())));
        collection.ensureSkiplistIndex(Collections.singleton(value.getFieldName()), options);
    }

    private static void ensurePersistentIndex(CollectionOperations collection, PersistentIndex annotation) {
        collection.ensurePersistentIndex(Arrays.asList(annotation.fields()), new PersistentIndexOptions().unique(Boolean.valueOf(annotation.unique())).sparse(Boolean.valueOf(annotation.sparse())));
    }

    private static void ensurePersistentIndex(CollectionOperations collection, ArangoPersistentProperty value) {
        PersistentIndexOptions options = new PersistentIndexOptions();
        value.getPersistentIndexed().ifPresent(i -> options.unique(Boolean.valueOf(i.unique())).sparse(Boolean.valueOf(i.sparse())));
        collection.ensurePersistentIndex(Collections.singleton(value.getFieldName()), options);
    }

    private static void ensureGeoIndex(CollectionOperations collection, GeoIndex annotation) {
        collection.ensureGeoIndex(Arrays.asList(annotation.fields()), new GeoIndexOptions().geoJson(Boolean.valueOf(annotation.geoJson())));
    }

    private static void ensureGeoIndex(CollectionOperations collection, ArangoPersistentProperty value) {
        GeoIndexOptions options = new GeoIndexOptions();
        value.getGeoIndexed().ifPresent(i -> options.geoJson(Boolean.valueOf(i.geoJson())));
        collection.ensureGeoIndex(Collections.singleton(value.getFieldName()), options);
    }

    private static void ensureFulltextIndex(CollectionOperations collection, FulltextIndex annotation) {
        collection.ensureFulltextIndex(Collections.singleton(annotation.field()), new FulltextIndexOptions().minLength(annotation.minLength() > -1 ? Integer.valueOf(annotation.minLength()) : null));
    }

    private static void ensureFulltextIndex(CollectionOperations collection, ArangoPersistentProperty value) {
        FulltextIndexOptions options = new FulltextIndexOptions();
        value.getFulltextIndexed().ifPresent(i -> options.minLength(i.minLength() > -1 ? Integer.valueOf(i.minLength()) : null));
        collection.ensureFulltextIndex(Collections.singleton(value.getFieldName()), options);
    }

    private static void ensureTtlIndex(CollectionOperations collection, TtlIndex annotation) {
        collection.ensureTtlIndex(Collections.singleton(annotation.field()), new TtlIndexOptions().expireAfter(Integer.valueOf(annotation.expireAfter())));
    }

    private static void ensureTtlIndex(CollectionOperations collection, ArangoPersistentProperty value) {
        TtlIndexOptions options = new TtlIndexOptions();
        value.getTtlIndexed().ifPresent(i -> options.expireAfter(Integer.valueOf(i.expireAfter())));
        collection.ensureTtlIndex(Collections.singleton(value.getFieldName()), options);
    }

    private Optional<String> determineCollectionFromId(Object id) {
        return id != null ? Optional.ofNullable(MetadataUtils.determineCollectionFromId(this.converter.convertId(id))) : Optional.empty();
    }

    private String determineDocumentKeyFromId(Object id) {
        return MetadataUtils.determineDocumentKeyFromId(this.converter.convertId(id));
    }

    private VPackSlice toVPack(Object source) {
        return this.converter.write(source);
    }

    private Collection<VPackSlice> toVPackCollection(Iterable<?> values) {
        ArrayList<VPackSlice> vpacks = new ArrayList<VPackSlice>();
        for (Object value : values) {
            vpacks.add(this.toVPack(value));
        }
        return vpacks;
    }

    private <T> T fromVPack(Class<T> entityClass, VPackSlice source) {
        Object result = this.converter.read(entityClass, source);
        if (result != null) {
            this.potentiallyEmitEvent(new AfterLoadEvent<Object>(result));
        }
        return (T)result;
    }

    @Override
    public ArangoDB driver() {
        return this.arango;
    }

    @Override
    public ArangoDBVersion getVersion() throws DataAccessException {
        try {
            if (this.version == null) {
                this.version = this.db().getVersion();
            }
            return this.version;
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public <T> ArangoCursor<T> query(String query, Class<T> entityClass) throws DataAccessException {
        return this.query(query, null, null, entityClass);
    }

    @Override
    public <T> ArangoCursor<T> query(String query, Map<String, Object> bindVars, Class<T> entityClass) throws DataAccessException {
        return this.query(query, bindVars, null, entityClass);
    }

    @Override
    public <T> ArangoCursor<T> query(String query, AqlQueryOptions options, Class<T> entityClass) throws DataAccessException {
        return this.query(query, null, options, entityClass);
    }

    @Override
    public <T> ArangoCursor<T> query(String query, Map<String, Object> bindVars, AqlQueryOptions options, Class<T> entityClass) throws DataAccessException {
        return this.db().query(query, bindVars == null ? null : this.prepareBindVars(bindVars), options, entityClass);
    }

    private Map<String, Object> prepareBindVars(Map<String, Object> bindVars) {
        HashMap<String, Object> prepared = new HashMap<String, Object>(bindVars.size());
        for (Map.Entry<String, Object> entry : bindVars.entrySet()) {
            if (entry.getKey().startsWith("@") && entry.getValue() instanceof Class) {
                prepared.put(entry.getKey(), this._collection((Class)entry.getValue()).name());
                continue;
            }
            prepared.put(entry.getKey(), this.toVPack(entry.getValue()));
        }
        return prepared;
    }

    @Override
    public MultiDocumentEntity<? extends DocumentEntity> delete(Iterable<Object> values, Class<?> entityClass, DocumentDeleteOptions options) throws DataAccessException {
        MultiDocumentEntity result;
        this.potentiallyEmitBeforeDeleteEvent(values, entityClass);
        try {
            result = this._collection(entityClass).deleteDocuments(this.toVPackCollection(values), entityClass, options);
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
        this.potentiallyEmitAfterDeleteEvent(values, entityClass, (MultiDocumentEntity<? extends DocumentEntity>)result);
        return result;
    }

    @Override
    public MultiDocumentEntity<? extends DocumentEntity> delete(Iterable<Object> values, Class<?> entityClass) throws DataAccessException {
        return this.delete(values, entityClass, new DocumentDeleteOptions());
    }

    @Override
    public DocumentEntity delete(Object id, Class<?> entityClass, DocumentDeleteOptions options) throws DataAccessException {
        DocumentDeleteEntity result;
        this.potentiallyEmitEvent(new BeforeDeleteEvent(id, entityClass));
        try {
            result = this._collection(entityClass, id).deleteDocument(this.determineDocumentKeyFromId(id), entityClass, options);
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
        this.potentiallyEmitEvent(new AfterDeleteEvent(id, entityClass));
        return result;
    }

    @Override
    public DocumentEntity delete(Object id, Class<?> entityClass) throws DataAccessException {
        return this.delete(id, entityClass, new DocumentDeleteOptions());
    }

    @Override
    public <T> MultiDocumentEntity<? extends DocumentEntity> update(Iterable<T> values, Class<T> entityClass, DocumentUpdateOptions options) throws DataAccessException {
        MultiDocumentEntity result;
        this.potentiallyEmitBeforeSaveEvent(values);
        try {
            result = this._collection(entityClass).updateDocuments(this.toVPackCollection(values), options);
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
        this.updateDBFields(values, (MultiDocumentEntity<? extends DocumentEntity>)result);
        this.potentiallyEmitAfterSaveEvent(values, (MultiDocumentEntity<? extends DocumentEntity>)result);
        return result;
    }

    @Override
    public <T> MultiDocumentEntity<? extends DocumentEntity> update(Iterable<T> values, Class<T> entityClass) throws DataAccessException {
        return this.update(values, entityClass, new DocumentUpdateOptions());
    }

    public DocumentEntity update(Object id, Object value, DocumentUpdateOptions options) throws DataAccessException {
        DocumentUpdateEntity result;
        this.potentiallyEmitEvent(new BeforeSaveEvent<Object>(value));
        try {
            result = this._collection(value.getClass(), id).updateDocument(this.determineDocumentKeyFromId(id), (Object)this.toVPack(value), options);
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
        this.updateDBFields(value, (DocumentEntity)result);
        this.potentiallyEmitEvent(new AfterSaveEvent<Object>(value));
        return result;
    }

    public DocumentEntity update(Object id, Object value) throws DataAccessException {
        return this.update(id, value, new DocumentUpdateOptions());
    }

    @Override
    public <T> MultiDocumentEntity<? extends DocumentEntity> replace(Iterable<T> values, Class<T> entityClass, DocumentReplaceOptions options) throws DataAccessException {
        MultiDocumentEntity result;
        this.potentiallyEmitBeforeSaveEvent(values);
        try {
            result = this._collection(entityClass).replaceDocuments(this.toVPackCollection(values), options);
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
        this.updateDBFields(values, (MultiDocumentEntity<? extends DocumentEntity>)result);
        this.potentiallyEmitAfterSaveEvent(values, (MultiDocumentEntity<? extends DocumentEntity>)result);
        return result;
    }

    @Override
    public <T> MultiDocumentEntity<? extends DocumentEntity> replace(Iterable<T> values, Class<T> entityClass) throws DataAccessException {
        return this.replace(values, entityClass, new DocumentReplaceOptions());
    }

    public DocumentEntity replace(Object id, Object value, DocumentReplaceOptions options) throws DataAccessException {
        DocumentUpdateEntity result;
        this.potentiallyEmitEvent(new BeforeSaveEvent<Object>(value));
        try {
            result = this._collection(value.getClass(), id).replaceDocument(this.determineDocumentKeyFromId(id), (Object)this.toVPack(value), options);
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
        this.updateDBFields(value, (DocumentEntity)result);
        this.potentiallyEmitEvent(new AfterSaveEvent<Object>(value));
        return result;
    }

    public DocumentEntity replace(Object id, Object value) throws DataAccessException {
        return this.replace(id, value, new DocumentReplaceOptions());
    }

    @Override
    public <T> Optional<T> find(Object id, Class<T> entityClass, DocumentReadOptions options) throws DataAccessException {
        try {
            VPackSlice doc = (VPackSlice)this._collection(entityClass, id).getDocument(this.determineDocumentKeyFromId(id), VPackSlice.class, options);
            return Optional.ofNullable(this.fromVPack(entityClass, doc));
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public <T> Optional<T> find(Object id, Class<T> entityClass) throws DataAccessException {
        return this.find(id, entityClass, new DocumentReadOptions());
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> entityClass) throws DataAccessException {
        String query = "FOR entity IN @@col RETURN entity";
        Map bindVars = new MapBuilder().put("@col", entityClass).get();
        return this.query("FOR entity IN @@col RETURN entity", bindVars, null, entityClass).asListRemaining();
    }

    @Override
    public <T> Iterable<T> find(Iterable<? extends Object> ids, Class<T> entityClass) throws DataAccessException {
        try {
            ArrayList keys = new ArrayList();
            ids.forEach(id -> keys.add(this.determineDocumentKeyFromId(id)));
            MultiDocumentEntity docs = this._collection(entityClass).getDocuments(keys, VPackSlice.class);
            return docs.getDocuments().stream().map(doc -> this.fromVPack(entityClass, (VPackSlice)doc)).collect(Collectors.toList());
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public <T> MultiDocumentEntity<? extends DocumentEntity> insert(Iterable<T> values, Class<T> entityClass, DocumentCreateOptions options) throws DataAccessException {
        MultiDocumentEntity result;
        this.potentiallyEmitBeforeSaveEvent(values);
        try {
            result = this._collection(entityClass).insertDocuments(this.toVPackCollection(values), options);
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
        this.updateDBFields(values, (MultiDocumentEntity<? extends DocumentEntity>)result);
        this.potentiallyEmitAfterSaveEvent(values, (MultiDocumentEntity<? extends DocumentEntity>)result);
        return result;
    }

    @Override
    public <T> MultiDocumentEntity<? extends DocumentEntity> insert(Iterable<T> values, Class<T> entityClass) throws DataAccessException {
        return this.insert(values, entityClass, new DocumentCreateOptions());
    }

    public DocumentEntity insert(Object value, DocumentCreateOptions options) throws DataAccessException {
        DocumentCreateEntity result;
        this.potentiallyEmitEvent(new BeforeSaveEvent<Object>(value));
        try {
            result = this._collection(value.getClass()).insertDocument((Object)this.toVPack(value), options);
        }
        catch (ArangoDBException e) {
            throw this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
        this.updateDBFields(value, (DocumentEntity)result);
        this.potentiallyEmitEvent(new AfterSaveEvent<Object>(value));
        return result;
    }

    public DocumentEntity insert(Object value) throws DataAccessException {
        return this.insert(value, new DocumentCreateOptions());
    }

    @Override
    public DocumentEntity insert(String collectionName, Object value, DocumentCreateOptions options) throws DataAccessException {
        DocumentCreateEntity result;
        this.potentiallyEmitEvent(new BeforeSaveEvent<Object>(value));
        try {
            result = this._collection(collectionName).insertDocument((Object)this.toVPack(value), options);
        }
        catch (ArangoDBException e) {
            throw this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
        this.updateDBFields(value, (DocumentEntity)result);
        this.potentiallyEmitEvent(new AfterSaveEvent<Object>(value));
        return result;
    }

    @Override
    public DocumentEntity insert(String collectionName, Object value) throws DataAccessException {
        return this.insert(collectionName, value, new DocumentCreateOptions());
    }

    private Object getDocumentKey(ArangoPersistentEntity<?> entity, Object value) {
        Object docId;
        Object id = entity.getIdentifierAccessor(value).getIdentifier();
        if (id == null && (docId = entity.getArangoIdAccessor(value).getIdentifier()) != null) {
            id = MetadataUtils.determineDocumentKeyFromId((String)docId);
        }
        return id;
    }

    @Override
    public <T> void upsert(T value, ArangoOperations.UpsertStrategy strategy) throws DataAccessException {
        Class<?> entityClass = value.getClass();
        ArangoPersistentEntity entity = (ArangoPersistentEntity)this.getConverter().getMappingContext().getPersistentEntity(entityClass);
        Object id = this.getDocumentKey(entity, value);
        if (!(id == null || value instanceof Persistable && ((Persistable)Persistable.class.cast(value)).isNew())) {
            switch (strategy) {
                case UPDATE: {
                    this.update((Object)id.toString(), (Object)value);
                    break;
                }
                default: {
                    this.replace((Object)id.toString(), (Object)value);
                }
            }
            return;
        }
        this.insert((Object)value);
    }

    @Override
    public <T> void upsert(Iterable<T> value, ArangoOperations.UpsertStrategy strategy) throws DataAccessException {
        Optional<T> first = StreamSupport.stream(value.spliterator(), false).findFirst();
        if (!first.isPresent()) {
            return;
        }
        Class<?> entityClass = first.get().getClass();
        ArangoPersistentEntity entity = (ArangoPersistentEntity)this.getConverter().getMappingContext().getPersistentEntity(entityClass);
        ArrayList<T> withId = new ArrayList<T>();
        ArrayList<T> withoutId = new ArrayList<T>();
        for (T e : value) {
            Object id = this.getDocumentKey(entity, e);
            if (!(id == null || e instanceof Persistable && ((Persistable)Persistable.class.cast(e)).isNew())) {
                withId.add(e);
                continue;
            }
            withoutId.add(e);
        }
        if (!withoutId.isEmpty()) {
            this.insert(withoutId, entityClass);
        }
        if (!withId.isEmpty()) {
            switch (strategy) {
                case UPDATE: {
                    this.update(withId, entityClass);
                    break;
                }
                default: {
                    this.replace(withId, entityClass);
                }
            }
        }
    }

    @Override
    public <T> void repsert(T value) throws DataAccessException {
        Object result;
        Class<?> clazz = value.getClass();
        String collectionName = this._collection(clazz).name();
        this.potentiallyEmitEvent(new BeforeSaveEvent<T>(value));
        try {
            result = this.query(REPSERT_QUERY, new MapBuilder().put("@col", (Object)collectionName).put("doc", value).get(), clazz).first();
        }
        catch (ArangoDBException e) {
            throw this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
        this.updateDBFieldsFromObject(value, result);
        this.potentiallyEmitEvent(new AfterSaveEvent<Object>(result));
    }

    @Override
    public <T> void repsert(Iterable<? extends T> values, Class<T> entityClass) throws DataAccessException {
        List result;
        if (!values.iterator().hasNext()) {
            return;
        }
        String collectionName = this._collection(entityClass).name();
        this.potentiallyEmitBeforeSaveEvent(values);
        try {
            result = this.query(REPSERT_MANY_QUERY, new MapBuilder().put("@col", (Object)collectionName).put("docs", values).get(), entityClass).asListRemaining();
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
        this.updateDBFieldsFromObjects(values, result);
        result.forEach(it -> this.potentiallyEmitEvent(new AfterSaveEvent<Object>(it)));
    }

    private void updateDBFieldsFromObjects(Iterable<?> values, Iterable<?> res) {
        Iterator<?> valueIterator = values.iterator();
        Iterator<?> resIterator = res.iterator();
        while (valueIterator.hasNext() && resIterator.hasNext()) {
            this.updateDBFieldsFromObject(valueIterator.next(), resIterator.next());
        }
    }

    private void updateDBFieldsFromObject(Object toModify, Object toRead) {
        ArangoPersistentEntity entityToRead = (ArangoPersistentEntity)this.converter.getMappingContext().getPersistentEntity(toRead.getClass());
        PersistentPropertyAccessor accessorToRead = entityToRead.getPropertyAccessor(toRead);
        ArangoPersistentProperty idPropertyToRead = (ArangoPersistentProperty)entityToRead.getIdProperty();
        Optional<ArangoPersistentProperty> arangoIdPropertyToReadOptional = entityToRead.getArangoIdProperty();
        Optional<ArangoPersistentProperty> revPropertyToReadOptional = entityToRead.getRevProperty();
        ArangoPersistentEntity entityToModify = (ArangoPersistentEntity)this.converter.getMappingContext().getPersistentEntity(toModify.getClass());
        PersistentPropertyAccessor accessorToWrite = entityToModify.getPropertyAccessor(toModify);
        ArangoPersistentProperty idPropertyToWrite = (ArangoPersistentProperty)entityToModify.getIdProperty();
        if (idPropertyToWrite != null && !idPropertyToWrite.isImmutable()) {
            accessorToWrite.setProperty((PersistentProperty)idPropertyToWrite, accessorToRead.getProperty((PersistentProperty)idPropertyToRead));
        }
        if (arangoIdPropertyToReadOptional.isPresent()) {
            ArangoPersistentProperty arangoIdPropertyToRead = arangoIdPropertyToReadOptional.get();
            entityToModify.getArangoIdProperty().filter(arangoId -> !arangoId.isImmutable()).ifPresent(arangoId -> accessorToWrite.setProperty((PersistentProperty)arangoId, accessorToRead.getProperty((PersistentProperty)arangoIdPropertyToRead)));
        }
        if (revPropertyToReadOptional.isPresent()) {
            ArangoPersistentProperty revPropertyToRead = revPropertyToReadOptional.get();
            entityToModify.getRevProperty().filter(rev -> !rev.isImmutable()).ifPresent(rev -> accessorToWrite.setProperty((PersistentProperty)rev, accessorToRead.getProperty((PersistentProperty)revPropertyToRead)));
        }
    }

    private <T> void updateDBFields(Iterable<T> values, MultiDocumentEntity<? extends DocumentEntity> res) {
        Iterator<T> valueIterator = values.iterator();
        if (res.getErrors().isEmpty()) {
            Iterator documentIterator = res.getDocuments().iterator();
            while (valueIterator.hasNext() && documentIterator.hasNext()) {
                this.updateDBFields(valueIterator.next(), (DocumentEntity)documentIterator.next());
            }
        } else {
            Iterator documentIterator = res.getDocumentsAndErrors().iterator();
            while (valueIterator.hasNext() && documentIterator.hasNext()) {
                Object nextDoc = documentIterator.next();
                T nextValue = valueIterator.next();
                if (!(nextDoc instanceof DocumentEntity)) continue;
                this.updateDBFields(nextValue, (DocumentEntity)nextDoc);
            }
        }
    }

    private void updateDBFields(Object value, DocumentEntity documentEntity) {
        ArangoPersistentEntity entity = (ArangoPersistentEntity)this.converter.getMappingContext().getPersistentEntity(value.getClass());
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(value);
        ArangoPersistentProperty idProperty = (ArangoPersistentProperty)entity.getIdProperty();
        if (idProperty != null && !idProperty.isImmutable()) {
            accessor.setProperty((PersistentProperty)idProperty, (Object)documentEntity.getKey());
        }
        entity.getArangoIdProperty().filter(arangoId -> !arangoId.isImmutable()).ifPresent(arangoId -> accessor.setProperty((PersistentProperty)arangoId, (Object)documentEntity.getId()));
        entity.getRevProperty().filter(rev -> !rev.isImmutable()).ifPresent(rev -> accessor.setProperty((PersistentProperty)rev, (Object)documentEntity.getRev()));
    }

    @Override
    public boolean exists(Object id, Class<?> entityClass) throws DataAccessException {
        try {
            return this._collection(entityClass).documentExists(this.determineDocumentKeyFromId(id));
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public void dropDatabase() throws DataAccessException {
        ArangoDatabase db = this.db();
        try {
            db.drop();
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
        this.databaseCache.remove(db.name());
        this.collectionCache.keySet().stream().filter(key -> key.getDb().equals(db.name())).forEach(key -> this.collectionCache.remove(key));
    }

    @Override
    public CollectionOperations collection(Class<?> entityClass) throws DataAccessException {
        return this.collection(this._collection(entityClass));
    }

    @Override
    public CollectionOperations collection(String name) throws DataAccessException {
        return this.collection(this._collection(name));
    }

    @Override
    public CollectionOperations collection(String name, CollectionCreateOptions options) throws DataAccessException {
        return this.collection(this._collection(name, null, options));
    }

    private CollectionOperations collection(ArangoCollection collection) {
        return new DefaultCollectionOperations(collection, this.collectionCache, this.exceptionTranslator);
    }

    @Override
    public UserOperations user(String username) {
        return new DefaultUserOperation(this.db(), username, this.exceptionTranslator, this);
    }

    @Override
    public Iterable<UserEntity> getUsers() throws DataAccessException {
        try {
            return this.arango.getUsers();
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public ArangoConverter getConverter() {
        return this.converter;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context.setRootObject((Object)applicationContext);
        this.context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)applicationContext));
        this.context.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
        this.eventPublisher = applicationContext;
        this.arango._setCursorInitializer((com.arangodb.util.ArangoCursorInitializer)new ArangoCursorInitializer(this.converter, (ApplicationEventPublisher)applicationContext));
    }

    private void potentiallyEmitEvent(ArangoMappingEvent<?> event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
    }

    private void potentiallyEmitBeforeSaveEvent(Iterable<?> values) {
        for (Object value : values) {
            this.potentiallyEmitEvent(new BeforeSaveEvent(value));
        }
    }

    private void potentiallyEmitAfterSaveEvent(Iterable<?> values, MultiDocumentEntity<? extends DocumentEntity> result) {
        Iterator<?> valueIterator = values.iterator();
        Iterator documentIterator = result.getDocumentsAndErrors().iterator();
        while (valueIterator.hasNext() && documentIterator.hasNext()) {
            Object nextDoc = documentIterator.next();
            Object nextValue = valueIterator.next();
            if (!(nextDoc instanceof DocumentEntity)) continue;
            this.potentiallyEmitEvent(new AfterSaveEvent(nextValue));
        }
    }

    private void potentiallyEmitBeforeDeleteEvent(Iterable<?> values, Class<?> type) {
        for (Object value : values) {
            this.potentiallyEmitEvent(new BeforeDeleteEvent(value, type));
        }
    }

    private void potentiallyEmitAfterDeleteEvent(Iterable<?> values, Class<?> entityClass, MultiDocumentEntity<? extends DocumentEntity> result) {
        Iterator<?> valueIterator = values.iterator();
        Iterator documentIterator = result.getDocumentsAndErrors().iterator();
        while (valueIterator.hasNext() && documentIterator.hasNext()) {
            Object nextDoc = documentIterator.next();
            Object nextValue = valueIterator.next();
            if (!(nextDoc instanceof DocumentEntity)) continue;
            this.potentiallyEmitEvent(new AfterDeleteEvent(nextValue, entityClass));
        }
    }

    @Override
    public ResolverFactory getResolverFactory() {
        return this.resolverFactory;
    }
}

