/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.repository;

import com.arangodb.springframework.core.convert.resolver.ReferenceResolver;
import com.arangodb.springframework.core.convert.resolver.ResolverFactory;
import com.arangodb.springframework.core.mapping.ArangoMappingContext;
import com.arangodb.springframework.core.mapping.ArangoPersistentEntity;
import com.arangodb.springframework.core.mapping.ArangoPersistentProperty;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ArangoExampleConverter<T> {
    private final ArangoMappingContext context;
    private final ResolverFactory resolverFactory;
    private static final Set<Character> SPECIAL_CHARACTERS = new HashSet<Character>();

    public ArangoExampleConverter(ArangoMappingContext context, ResolverFactory resolverFactory) {
        this.context = context;
        this.resolverFactory = resolverFactory;
    }

    public String convertExampleToPredicate(Example<T> example, Map<String, Object> bindVars) {
        StringBuilder predicateBuilder = new StringBuilder();
        ArangoPersistentEntity persistentEntity = (ArangoPersistentEntity)this.context.getPersistentEntity(example.getProbeType());
        Assert.isTrue((example.getProbe() != null ? 1 : 0) != 0, (String)"Probe in Example cannot be null");
        String bindEntintyName = "e";
        this.traversePropertyTree(example, predicateBuilder, bindVars, "", "", persistentEntity, example.getProbe(), "e");
        return predicateBuilder.toString();
    }

    private void traversePropertyTree(Example<T> example, StringBuilder predicateBuilder, Map<String, Object> bindVars, String path, String javaPath, ArangoPersistentEntity<?> entity, Object object, String bindEntintyName) {
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(object);
        entity.doWithProperties(property -> {
            if (property.getFrom().isPresent() || property.getTo().isPresent() || property.getRelations().isPresent()) {
                return;
            }
            String fullPath = path + (path.length() == 0 ? "" : ".") + property.getFieldName();
            String fullJavaPath = javaPath + (javaPath.length() == 0 ? "" : ".") + property.getName();
            Object value = accessor.getProperty(property);
            if (property.isCollectionLike() && value != null) {
                String delimiter;
                ArangoPersistentEntity persistentEntity = (ArangoPersistentEntity)this.context.getPersistentEntity(property.getActualType());
                StringBuilder predicateBuilderArray = new StringBuilder();
                for (Object item : (Iterable)value) {
                    StringBuilder predicateBuilderArrayItem = new StringBuilder();
                    if (ClassUtils.isPrimitiveOrWrapper(item.getClass()) || item.getClass() == String.class) {
                        this.addPredicate(example, predicateBuilderArrayItem, bindVars, null, fullJavaPath, item, "CURRENT");
                    } else {
                        this.traversePropertyTree(example, predicateBuilderArrayItem, bindVars, "", fullJavaPath, persistentEntity, item, "CURRENT");
                    }
                    if (predicateBuilderArray.length() > 0) {
                        predicateBuilderArray.append(" OR ");
                    }
                    predicateBuilderArray.append(predicateBuilderArrayItem.toString());
                }
                String string = delimiter = example.getMatcher().isAllMatching() ? " AND " : " OR ";
                if (predicateBuilder.length() > 0) {
                    predicateBuilder.append(delimiter);
                }
                String clause = String.format("LENGTH(%s.%s[* FILTER %s ])>0", bindEntintyName, property.getName(), predicateBuilderArray.toString());
                predicateBuilder.append(clause);
            } else if (property.isEntity() && value != null) {
                ArangoPersistentEntity persistentEntity = (ArangoPersistentEntity)this.context.getPersistentEntity(property.getType());
                this.traversePropertyTree(example, predicateBuilder, bindVars, fullPath, fullJavaPath, persistentEntity, value, bindEntintyName);
            } else if (!example.getMatcher().isIgnoredPath(fullJavaPath) && (value != null || example.getMatcher().getNullHandler().equals((Object)ExampleMatcher.NullHandler.INCLUDE))) {
                this.addPredicate(example, predicateBuilder, bindVars, fullPath, fullJavaPath, value, bindEntintyName);
            }
        });
        entity.doWithAssociations(association -> {
            ArangoPersistentProperty property = (ArangoPersistentProperty)association.getInverse();
            String fullPath = path + (path.length() == 0 ? "" : ".") + property.getFieldName();
            String fullJavaPath = javaPath + (javaPath.length() == 0 ? "" : ".") + property.getName();
            Object value = accessor.getProperty((PersistentProperty)property);
            if (property.isEntity() && property.isAssociation() && value != null) {
                ArangoPersistentEntity persistentEntity = (ArangoPersistentEntity)this.context.getPersistentEntity(property.getType());
                PersistentPropertyAccessor associatedAccessor = persistentEntity.getPropertyAccessor(value);
                Object idValue = associatedAccessor.getProperty(persistentEntity.getIdProperty());
                String refIdValue = null;
                if (property.getRef().isPresent()) {
                    Optional<ReferenceResolver<Annotation>> resolver = this.resolverFactory.getReferenceResolver((Annotation)property.getRef().get());
                    refIdValue = resolver.get().write(value, persistentEntity, idValue, property.getRef().get());
                } else {
                    refIdValue = String.format("%s/%s", persistentEntity.getCollection(), idValue);
                }
                this.addPredicate(example, predicateBuilder, bindVars, fullPath, fullJavaPath, refIdValue, bindEntintyName);
            }
        });
    }

    private void addPredicate(Example<T> example, StringBuilder predicateBuilder, Map<String, Object> bindVars, String fullPath, String fullJavaPath, Object value, String bindEntintyName) {
        String clause;
        String delimiter;
        String string = delimiter = example.getMatcher().isAllMatching() ? " AND " : " OR ";
        if (predicateBuilder.length() > 0) {
            predicateBuilder.append(delimiter);
        }
        String binding = Integer.toString(bindVars.size());
        ExampleMatcher.PropertySpecifier specifier = example.getMatcher().getPropertySpecifiers().getForPath(fullPath);
        if (specifier != null && value != null) {
            value = specifier.transformValue(Optional.of(value)).orElse(null);
        }
        if (value == null) {
            clause = String.format("%s.%s == null", bindEntintyName, fullPath);
        } else if (String.class.isAssignableFrom(value.getClass())) {
            boolean ignoreCase = specifier == null ? example.getMatcher().isIgnoreCaseEnabled() : (specifier.getIgnoreCase() == null ? false : specifier.getIgnoreCase());
            ExampleMatcher.StringMatcher stringMatcher = specifier == null || specifier.getStringMatcher() == ExampleMatcher.StringMatcher.DEFAULT ? example.getMatcher().getDefaultStringMatcher() : specifier.getStringMatcher();
            String string2 = (String)value;
            clause = stringMatcher == ExampleMatcher.StringMatcher.REGEX ? (Objects.isNull(fullPath) ? String.format("REGEX_TEST(%s, @%s, %b)", bindEntintyName, binding, ignoreCase) : String.format("REGEX_TEST(%s.%s, @%s, %b)", bindEntintyName, fullPath, binding, ignoreCase)) : (Objects.isNull(fullPath) ? String.format("LIKE(%s, @%s, %b)", bindEntintyName, binding, ignoreCase) : String.format("LIKE(%s.%s, @%s, %b)", bindEntintyName, fullPath, binding, ignoreCase));
            switch (stringMatcher) {
                case STARTING: {
                    value = ArangoExampleConverter.escape(string2) + "%";
                    break;
                }
                case ENDING: {
                    value = "%" + ArangoExampleConverter.escape(string2);
                    break;
                }
                case CONTAINING: {
                    value = "%" + ArangoExampleConverter.escape(string2) + "%";
                    break;
                }
                case REGEX: {
                    value = ArangoExampleConverter.escape(string2);
                    break;
                }
                default: {
                    value = ArangoExampleConverter.escape(string2);
                    break;
                }
            }
        } else {
            clause = Objects.isNull(fullPath) ? String.format("%s == @%s", bindEntintyName, binding) : String.format("%s.%s == @%s", bindEntintyName, fullPath, binding);
        }
        predicateBuilder.append(clause);
        if (value != null) {
            bindVars.put(binding, value);
        }
    }

    private static String escape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character character = Character.valueOf(cArray[i]);
            if (SPECIAL_CHARACTERS.contains(character)) {
                stringBuilder.append('\\');
            }
            stringBuilder.append(character);
        }
        return stringBuilder.toString();
    }

    static {
        SPECIAL_CHARACTERS.add(Character.valueOf('\\'));
        SPECIAL_CHARACTERS.add(Character.valueOf('_'));
        SPECIAL_CHARACTERS.add(Character.valueOf('%'));
    }
}

