/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.repository;

import com.arangodb.ArangoCursor;
import com.arangodb.model.AqlQueryOptions;
import com.arangodb.springframework.core.ArangoOperations;
import com.arangodb.springframework.core.mapping.ArangoMappingContext;
import com.arangodb.springframework.core.mapping.ArangoPersistentEntity;
import com.arangodb.springframework.core.mapping.ArangoPersistentProperty;
import com.arangodb.springframework.core.util.AqlUtils;
import com.arangodb.springframework.repository.ArangoExampleConverter;
import com.arangodb.springframework.repository.ArangoRepository;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Repository;

@Repository
public class SimpleArangoRepository<T, ID>
implements ArangoRepository<T, ID> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleArangoRepository.class);
    private final ArangoOperations arangoOperations;
    private final ArangoExampleConverter exampleConverter;
    private final Class<T> domainClass;

    public SimpleArangoRepository(ArangoOperations arangoOperations, Class<T> domainClass) {
        this.arangoOperations = arangoOperations;
        this.domainClass = domainClass;
        this.exampleConverter = new ArangoExampleConverter((ArangoMappingContext)arangoOperations.getConverter().getMappingContext(), arangoOperations.getResolverFactory());
    }

    public <S extends T> S save(S entity) {
        this.arangoOperations.repsert(entity);
        return entity;
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        this.arangoOperations.repsert(entities, this.domainClass);
        return entities;
    }

    public Optional<T> findById(ID id) {
        return this.arangoOperations.find(id, this.domainClass);
    }

    public boolean existsById(ID id) {
        return this.arangoOperations.exists(id, this.domainClass);
    }

    public Iterable<T> findAll() {
        return this.arangoOperations.findAll(this.domainClass);
    }

    public Iterable<T> findAllById(Iterable<ID> ids) {
        return this.arangoOperations.find(ids, this.domainClass);
    }

    public long count() {
        return this.arangoOperations.collection(this.domainClass).count();
    }

    public void deleteById(ID id) {
        this.arangoOperations.delete(id, this.domainClass);
    }

    public void delete(T entity) {
        String id = null;
        try {
            id = (String)((ArangoPersistentProperty)((ArangoPersistentEntity)this.arangoOperations.getConverter().getMappingContext().getPersistentEntity(this.domainClass)).getIdProperty()).getField().get(entity);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.arangoOperations.delete(id, this.domainClass);
    }

    public void deleteAll(Iterable<? extends T> entities) {
        entities.forEach(this::delete);
    }

    public void deleteAll() {
        this.arangoOperations.collection(this.domainClass).truncate();
    }

    public Iterable<T> findAll(final Sort sort) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return SimpleArangoRepository.this.findAllInternal(sort, null, (Map<String, Object>)new HashMap());
            }
        };
    }

    public Page<T> findAll(Pageable pageable) {
        if (pageable == null) {
            LOGGER.debug("Pageable in findAll(Pageable) is null");
        }
        ArangoCursor<T> result = this.findAllInternal(pageable, null, new HashMap<String, Object>());
        List content = result.asListRemaining();
        return new PageImpl(content, pageable, result.getStats().getFullCount().longValue());
    }

    private String getCollectionName() {
        return ((ArangoPersistentEntity)this.arangoOperations.getConverter().getMappingContext().getPersistentEntity(this.domainClass)).getCollection();
    }

    public <S extends T> Optional<S> findOne(Example<S> example) {
        ArangoCursor<T> cursor = this.findAllInternal((Pageable)null, example, new HashMap<String, Object>());
        return cursor.hasNext() ? Optional.ofNullable(cursor.next()) : Optional.empty();
    }

    public <S extends T> Iterable<S> findAll(Example<S> example) {
        ArangoCursor<T> cursor = this.findAllInternal((Pageable)null, example, new HashMap<String, Object>());
        return cursor;
    }

    public <S extends T> Iterable<S> findAll(Example<S> example, Sort sort) {
        ArangoCursor<T> cursor = this.findAllInternal(sort, example, new HashMap<String, Object>());
        return cursor;
    }

    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        ArangoCursor<T> cursor = this.findAllInternal(pageable, example, new HashMap<String, Object>());
        List content = cursor.asListRemaining();
        return new PageImpl(content, pageable, cursor.getStats().getFullCount().longValue());
    }

    public <S extends T> long count(Example<S> example) {
        HashMap<String, Object> bindVars = new HashMap<String, Object>();
        String predicate = this.exampleConverter.convertExampleToPredicate(example, bindVars);
        String filter = predicate.length() == 0 ? "" : " FILTER " + predicate;
        String query = String.format("FOR e IN %s%s COLLECT WITH COUNT INTO length RETURN length", this.getCollectionName(), filter);
        this.arangoOperations.collection(this.domainClass);
        ArangoCursor<Long> cursor = this.arangoOperations.query(query, bindVars, null, Long.class);
        return (Long)cursor.next();
    }

    public <S extends T> boolean exists(Example<S> example) {
        return this.count(example) > 0L;
    }

    private <S extends T> ArangoCursor<T> findAllInternal(Sort sort, @Nullable Example<S> example, Map<String, Object> bindVars) {
        String query = String.format("FOR e IN %s %s %s RETURN e", this.getCollectionName(), this.buildFilterClause(example, bindVars), this.buildSortClause(sort, "e"));
        this.arangoOperations.collection(this.domainClass);
        return this.arangoOperations.query(query, bindVars, null, this.domainClass);
    }

    private <S extends T> ArangoCursor<T> findAllInternal(Pageable pageable, @Nullable Example<S> example, Map<String, Object> bindVars) {
        String query = String.format("FOR e IN %s %s %s RETURN e", this.getCollectionName(), this.buildFilterClause(example, bindVars), this.buildPageableClause(pageable, "e"));
        this.arangoOperations.collection(this.domainClass);
        return this.arangoOperations.query(query, bindVars, pageable != null && pageable.isPaged() ? new AqlQueryOptions().fullCount(Boolean.valueOf(true)) : null, this.domainClass);
    }

    private <S extends T> String buildFilterClause(Example<S> example, Map<String, Object> bindVars) {
        if (example == null) {
            return "";
        }
        String predicate = this.exampleConverter.convertExampleToPredicate(example, bindVars);
        return predicate == null ? "" : "FILTER " + predicate;
    }

    private String buildPageableClause(Pageable pageable, String varName) {
        return pageable == null ? "" : AqlUtils.buildPageableClause(pageable, varName);
    }

    private String buildSortClause(Sort sort, String varName) {
        return sort == null ? "" : AqlUtils.buildSortClause(sort, varName);
    }
}

