/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.repository.query;

import com.arangodb.model.AqlQueryOptions;
import com.arangodb.springframework.annotation.Query;
import com.arangodb.springframework.annotation.QueryOptions;
import com.arangodb.springframework.repository.query.ArangoParameters;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.geo.GeoPage;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.StringUtils;

public class ArangoQueryMethod
extends QueryMethod {
    private static final List<Class<?>> GEO_TYPES = Arrays.asList(GeoResult.class, GeoResults.class, GeoPage.class);
    private final Method method;
    private final TypeInformation<?> returnType;

    public ArangoQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory) {
        super(method, metadata, factory);
        this.method = method;
        this.returnType = ClassTypeInformation.from((Class)metadata.getRepositoryInterface()).getReturnType(method);
    }

    public ArangoParameters getParameters() {
        return (ArangoParameters)super.getParameters();
    }

    public ArangoParameters createParameters(Method method) {
        return new ArangoParameters(method);
    }

    public boolean hasAnnotatedQuery() {
        return this.getQueryAnnotationValue().isPresent();
    }

    public String getAnnotatedQuery() {
        return this.getQueryAnnotationValue().orElse(null);
    }

    public Query getQueryAnnotation() {
        return (Query)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, Query.class);
    }

    private Optional<String> getQueryAnnotationValue() {
        return Optional.ofNullable(this.getQueryAnnotation()).map(q -> q.value()).filter(StringUtils::hasText);
    }

    public boolean hasAnnotatedQueryOptions() {
        return this.getQueryOptionsAnnotation() != null;
    }

    public AqlQueryOptions getAnnotatedQueryOptions() {
        boolean allowDirtyRead;
        long memoryLimit;
        int ttl;
        int maxPlans;
        QueryOptions queryOptions = this.getQueryOptionsAnnotation();
        if (queryOptions == null) {
            return null;
        }
        AqlQueryOptions options = new AqlQueryOptions();
        int batchSize = queryOptions.batchSize();
        if (batchSize != -1) {
            options.batchSize(Integer.valueOf(batchSize));
        }
        if ((maxPlans = queryOptions.maxPlans()) != -1) {
            options.maxPlans(Integer.valueOf(maxPlans));
        }
        if ((ttl = queryOptions.ttl()) != -1) {
            options.ttl(Integer.valueOf(ttl));
        }
        options.cache(Boolean.valueOf(queryOptions.cache()));
        options.count(Boolean.valueOf(queryOptions.count()));
        options.fullCount(Boolean.valueOf(queryOptions.fullCount()));
        options.profile(Boolean.valueOf(queryOptions.profile()));
        options.rules(Arrays.asList(queryOptions.rules()));
        boolean stream = queryOptions.stream();
        if (stream) {
            options.stream(Boolean.valueOf(stream));
        }
        if ((memoryLimit = queryOptions.memoryLimit()) != -1L) {
            options.memoryLimit(Long.valueOf(memoryLimit));
        }
        if (allowDirtyRead = queryOptions.allowDirtyRead()) {
            options.allowDirtyRead(Boolean.valueOf(allowDirtyRead));
        }
        return options;
    }

    public QueryOptions getQueryOptionsAnnotation() {
        return (QueryOptions)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, QueryOptions.class);
    }

    public TypeInformation<?> getReturnType() {
        return this.returnType;
    }

    public boolean isGeoQuery() {
        Class<?> returnType = this.method.getReturnType();
        for (Class<?> type : GEO_TYPES) {
            if (!type.isAssignableFrom(returnType)) continue;
            return true;
        }
        return false;
    }
}

